/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.packaging;

import fr.fastconnect.factory.tibco.bw.maven.packaging.AbstractPackagingMojo;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="extract-xml-from-ear", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class ExtractXMLFromEARMojo
extends AbstractPackagingMojo {
    protected static final String CREATE_XML_FROM_EAR_SUCCESS = "Successfully extracted the XML Deployment Descriptor to ";
    protected static final String CREATE_XML_FROM_EAR_FAILED = "The extraction of the XML Deployment Descriptor file from the EAR file has failed.";

    @Override
    protected String getArtifactFileExtension() {
        return ".xml";
    }

    private void createXML() throws MojoExecutionException, IOException {
        this.checkAppManage();
        String earPath = this.getProject().getArtifact().getFile().getPath();
        String xmlOutputFile = this.deploymentDescriptor.getPath();
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-export");
        arguments.add("-max");
        arguments.add("-ear");
        arguments.add(earPath);
        arguments.add("-out");
        arguments.add(xmlOutputFile);
        ArrayList<File> tras = new ArrayList<File>();
        tras.add(this.tibcoAppManageTRAPath);
        this.launchTIBCOBinary(this.tibcoAppManagePath, tras, arguments, this.directory, CREATE_XML_FROM_EAR_FAILED);
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (super.skip()) {
            return;
        }
        try {
            this.createXML();
            this.getLog().info((CharSequence)("Successfully extracted the XML Deployment Descriptor to  '" + this.deploymentDescriptor + "'"));
        }
        catch (IOException e) {
            throw new MojoExecutionException(CREATE_XML_FROM_EAR_FAILED, (Exception)e);
        }
    }
}

