/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.packaging;

import fr.fastconnect.factory.tibco.bw.maven.packaging.AbstractPackagingMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.POMManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.EmptyFileFilter;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.enforcer.RequireProperty;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="generate-pom", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class GeneratePOM
extends AbstractPackagingMojo {
    protected static final String MODULE_SEPARATOR = "/";
    protected static final String GENERATING_POM_DEPLOY = "Generating deployment POM in ";
    protected static final String FAILURE_POM_DEPLOY = "Unable to create deployment POM";
    protected static final String WARN_NO_PARENT = "The property 'useParent' is set but no parent was found";
    @Parameter(property="deploy.pom", required=true, defaultValue="pom.xml")
    protected String pomDeployFilename;
    @Parameter
    protected List<String> excludedModules;
    @Parameter
    protected List<String> includedModules;
    @Parameter
    protected List<String> deployProperties;
    @Parameter(property="deploy.project.name", required=false)
    protected String deployedProjectName;
    @Parameter(property="tibco.domain.name", required=false)
    protected String domainName;
    @Parameter(property="tibco.domain.username", required=false)
    protected String domainUsername;
    @Parameter(property="tibco.domain.password", required=false)
    protected String domainPassword;
    @Parameter(property="generate.pom.use.parent", required=false, defaultValue="false")
    protected boolean useParent;
    @Parameter(property="generate.pom.ignore.parent", required=false)
    protected String ignoredParent;
    @Parameter(required=false)
    private List<RequireProperty> rules;
    @Parameter(property="generate.pom.parent.groupId", required=true)
    protected String parentGroupId;
    @Parameter(property="generate.pom.parent.artifactId", required=true)
    protected String parentArtifactId;
    @Parameter(property="generate.pom.parent.version", required=true)
    protected String parentVersion;
    @Parameter(property="generate.pom.parent.suffix", required=true, defaultValue="deploy")
    protected String parentArtifactSuffix;
    @Parameter(property="generate.pom.skip", required=false, defaultValue="false")
    protected boolean skipGeneratePom;
    @Parameter(property="package.bw.applications.root", defaultValue="applications", required=true)
    public String applicationsRoot;
    @Component
    private ArtifactMetadataSource artifactMetadataSource;
    @Component
    private PluginDescriptor pluginDescriptor;

    @Override
    protected String getArtifactFileExtension() {
        return ".xml";
    }

    private void updateProperty(String propertyName, String propertyValue, Model model) {
        if (propertyValue != null) {
            model.getProperties().setProperty(propertyName, propertyValue);
        }
    }

    private File updateProperties(Model model, MavenProject project) throws IOException, XmlPullParserException {
        Model projectModel;
        File result = null;
        if (project != null && project.getParent() != null) {
            result = this.updateProperties(model, project.getParent());
        }
        if (project.getPackaging().equals("pom")) {
            Model deployPomModel;
            File packageDirectory = new File((String)project.getProperties().get("project.package.directory"));
            File deployPOM = new File(packageDirectory + File.separator + this.pomDeployFilename);
            Boolean isEmpty = EmptyFileFilter.EMPTY.accept(deployPOM);
            if (deployPOM.exists() && !isEmpty.booleanValue() && (deployPomModel = POMManager.getModelFromPOM(deployPOM, this.getLog())).getGroupId().equals(this.parentGroupId) && deployPomModel.getArtifactId().equals(this.parentArtifactId + this.getArtifactSuffix())) {
                result = deployPOM;
            }
        }
        if (project.getFile() != null) {
            this.getLog().debug((CharSequence)("Using model in POM : " + project.getFile().getAbsolutePath()));
            projectModel = POMManager.getModelFromPOM(project.getFile(), this.getLog());
        } else {
            projectModel = project.getModel();
        }
        Properties properties = projectModel.getProperties();
        List activeProfiles = project.getActiveProfiles();
        ArrayList<String> activeProfilesIds = new ArrayList<String>();
        for (Profile profile : activeProfiles) {
            activeProfilesIds.add(profile.getId());
        }
        for (Profile profile : projectModel.getProfiles()) {
            if (!activeProfilesIds.contains(profile.getId())) continue;
            properties.putAll((Map<?, ?>)profile.getProperties());
        }
        ArrayList<String> ignoredProperties = new ArrayList<String>();
        String propertyValue = properties.getProperty("deploy.project.name");
        if (propertyValue != null) {
            model.getProperties().setProperty("deploy.project.name", propertyValue);
        }
        ignoredProperties.add("deploy.project.name");
        String s = project.getProperties().getProperty("deploy.descriptor.final");
        this.getLog().debug((CharSequence)s);
        File f = new File(s);
        this.updateProperty("deploy.descriptor", f.getName(), model);
        this.updateProperty("deploy.descriptor.final", project.getArtifactId() + "-deploy.xml", model);
        ignoredProperties.add("deploy.descriptor");
        ignoredProperties.add("deploy.descriptor.final");
        ignoredProperties.add("deploy.properties.globalVariables");
        ignoredProperties.add("deploy.properties.services");
        ignoredProperties.add("deploy.properties.globalVariables.reference");
        ignoredProperties.add("deploy.properties.services.reference");
        ignoredProperties.add("deploy.properties.globalVariables.common");
        ignoredProperties.add("deploy.properties.services.common");
        if (!this.isParentIgnored(project)) {
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                if (ignoredProperties.contains(propertyName) || (propertyValue = properties.getProperty(propertyName)) == null) continue;
                model.getProperties().setProperty(propertyName, propertyValue);
            }
        }
        return result;
    }

    private List<String> getActiveModules(List<Profile> activeProfiles, Model model) {
        List modules = model.getModules();
        for (Profile profile : model.getProfiles()) {
            Boolean found = false;
            for (Profile p : activeProfiles) {
                if (!p.getId().equals(profile.getId())) continue;
                found = true;
                break;
            }
            if (!found.booleanValue()) continue;
            for (String module : profile.getModules()) {
                if (modules.indexOf(module) >= 0) continue;
                modules.add(module);
            }
        }
        return modules;
    }

    private Model addModules(Model model, MavenProject project) throws IOException, XmlPullParserException {
        if (model == null || project == null) {
            return null;
        }
        List activeProjects = this.getSession().getProjects();
        List<String> modules = this.addModules(project, activeProjects);
        for (String module : modules) {
            String regex;
            this.getLog().debug((CharSequence)("module : " + module));
            boolean excluded = false;
            for (String exclude : this.excludedModules) {
                regex = GeneratePOM.wildcardToRegex(exclude);
                if (exclude == null || !Pattern.matches(regex, module)) continue;
                excluded = true;
                break;
            }
            if (excluded) continue;
            if (this.includedModules.isEmpty()) {
                model.addModule(module);
                continue;
            }
            for (String include : this.includedModules) {
                regex = GeneratePOM.wildcardToRegex(include);
                if (include == null || !Pattern.matches(regex, module)) continue;
                model.addModule(module);
            }
        }
        return model;
    }

    private void copyToModules(File outputFile, Model model, MavenProject project) throws IOException, XmlPullParserException {
        if (outputFile == null || model == null || project == null) {
            return;
        }
        List activeProjects = this.getSession().getProjects();
        this.copyToModules(outputFile, project, activeProjects);
    }

    private List<Profile> getActiveProfiles(List<MavenProject> projects) {
        ArrayList<Profile> result = new ArrayList<Profile>();
        for (MavenProject project : projects) {
            result.addAll(project.getActiveProfiles());
        }
        return result;
    }

    private void copyToModules(File outputFile, MavenProject project, List<MavenProject> activeProjects) throws IOException, XmlPullParserException {
        this.copyToModules(outputFile, project.getBasedir() + File.separator, project.getModel(), this.getActiveProfiles(activeProjects), activeProjects);
    }

    private void copyToModules(File outputFile, String basedir, Model model, List<Profile> activeProfiles, List<MavenProject> activeProjects) throws IOException, XmlPullParserException {
        List<String> modules = this.getActiveModules(activeProfiles, model);
        for (String module : modules) {
            String childFileName = basedir + module + File.separator + "pom.xml";
            if (!new File(childFileName).exists()) continue;
            Model child = POMManager.getModelFromPOM(new File(childFileName), this.getLog());
            MavenProject mavenProject = null;
            if (child.getPackaging().equals("bw-ear") && (mavenProject = this.isProjectActive(child, activeProjects)) != null) {
                File destinationFile = new File(mavenProject.getBuild().getDirectory() + File.separator + this.deployedProjectName);
                FileUtils.copyFile((File)outputFile, (File)destinationFile);
                this.getLog().debug((CharSequence)("Copying deployment POM '" + outputFile.getAbsolutePath() + "' to: " + destinationFile.getAbsolutePath()));
                continue;
            }
            if (!child.getPackaging().equals("pom")) continue;
            this.copyToModules(outputFile, basedir + module + File.separator, child, activeProfiles, activeProjects);
        }
    }

    private List<String> addModules(MavenProject project, List<MavenProject> activeProjects) throws IOException, XmlPullParserException {
        return this.addModules(project.getBasedir() + File.separator, project.getModel(), this.getActiveProfiles(activeProjects), activeProjects);
    }

    private List<String> addModules(String basedir, Model model, List<Profile> activeProfiles, List<MavenProject> activeProjects) throws IOException, XmlPullParserException {
        ArrayList<String> result = new ArrayList<String>();
        List<String> modules = this.getActiveModules(activeProfiles, model);
        for (String module : modules) {
            String childFileName = basedir + module + File.separator + "pom.xml";
            if (!new File(childFileName).exists()) continue;
            Model child = POMManager.getModelFromPOM(new File(childFileName), this.getLog());
            if (child.getPackaging().equals("bw-ear")) {
                if (this.isProjectActive(child, activeProjects) == null) continue;
                String relativePath = this.getModuleRelativePath(child);
                result.add(this.applicationsRoot + MODULE_SEPARATOR + relativePath);
                continue;
            }
            if (!child.getPackaging().equals("pom")) continue;
            result.addAll(this.addModules(basedir + module + File.separator, child, activeProfiles, activeProjects));
        }
        return result;
    }

    private String getModuleRelativePath(Model child) {
        String result = child.getProperties().getProperty("assembly.relative.path");
        if (result == null || result.isEmpty()) {
            result = ".";
        }
        result = result + MODULE_SEPARATOR + child.getArtifactId() + MODULE_SEPARATOR + this.pomDeployFilename;
        return result;
    }

    private MavenProject isProjectActive(Model model, List<MavenProject> activeProjects) {
        for (MavenProject mavenProject : activeProjects) {
            boolean packageSkip;
            String packageSkipProperty = mavenProject.getProperties().getProperty("bw.package.skip");
            boolean bl = packageSkip = packageSkipProperty != null && packageSkipProperty.equals("true");
            if (!mavenProject.getGroupId().equals(model.getGroupId()) && model.getGroupId() != null || !mavenProject.getArtifactId().equals(model.getArtifactId()) || !mavenProject.getVersion().equals(model.getVersion()) && model.getVersion() != null || packageSkip) continue;
            return mavenProject;
        }
        return null;
    }

    protected boolean isParentIgnored(MavenProject parent) {
        if (this.ignoredParent == null) {
            return false;
        }
        return this.ignoredParent.equals(parent.getGroupId() + ":" + parent.getArtifactId());
    }

    private Model addParent(Model model, String parentGroupId, String parentArtifactId, String parentVersion) {
        if (model == null) {
            return null;
        }
        Parent p = new Parent();
        p.setGroupId(parentGroupId);
        p.setArtifactId(parentArtifactId);
        p.setVersion(parentVersion);
        if (!(model.getGroupId() + ":" + model.getArtifactId()).equals(parentGroupId + ":" + parentArtifactId)) {
            model.setParent(p);
        }
        return model;
    }

    @Override
    protected File getOutputFile() {
        return new File(this.packageDirectory + File.separator + this.pomDeployFilename);
    }

    private List<MojoExecutor.Element> getConfiguration(List<RequireProperty> rules) {
        ArrayList<MojoExecutor.Element> result = new ArrayList<MojoExecutor.Element>();
        if (rules != null) {
            this.getLog().debug((CharSequence)rules.toString());
            for (RequireProperty rule : rules) {
                ArrayList<MojoExecutor.Element> children = new ArrayList<MojoExecutor.Element>();
                children.add(MojoExecutor.element((String)"message", (String)rule.getMessage()));
                children.add(MojoExecutor.element((String)"property", (String)rule.getPropertyName()));
                children.add(MojoExecutor.element((String)"regex", (String)rule.getRegex()));
                children.add(MojoExecutor.element((String)"regexMessage", (String)rule.getRegexMessage()));
                result.add(MojoExecutor.element((String)"requireProperty", (MojoExecutor.Element[])children.toArray(new MojoExecutor.Element[0])));
            }
        }
        return result;
    }

    private void updateBuildForPOM(Model model) {
        Plugin propertiesPlugin = new Plugin();
        propertiesPlugin.setGroupId("org.kuali.maven.plugins");
        propertiesPlugin.setArtifactId("properties-maven-plugin");
        propertiesPlugin.setVersion("2.0.1");
        Xpp3Dom config = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"locations", (MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"location", (String)"${externalPropertiesFile}")}), MojoExecutor.element((String)"quiet", (String)"true")});
        propertiesPlugin.setConfiguration((Object)config);
        ArrayList<PluginExecution> executions = new ArrayList<PluginExecution>();
        PluginExecution execution = new PluginExecution();
        execution.setId("inject-external-properties-file");
        execution.addGoal("read-project-properties");
        execution.setPhase("validate");
        executions.add(execution);
        propertiesPlugin.setExecutions(executions);
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        model.getBuild().addPlugin(propertiesPlugin);
        if (this.rules != null) {
            Plugin enforcerPlugin = new Plugin();
            enforcerPlugin.setArtifactId("maven-enforcer-plugin");
            enforcerPlugin.setVersion("1.3.1");
            config = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"rules", (MojoExecutor.Element[])this.getConfiguration(this.rules).toArray(new MojoExecutor.Element[0])), MojoExecutor.element((String)"fail", (String)"true")});
            enforcerPlugin.setConfiguration((Object)config);
            executions = new ArrayList();
            execution = new PluginExecution();
            execution.setId("enforce");
            execution.addGoal("enforce");
            execution.setPhase("validate");
            executions.add(execution);
            enforcerPlugin.setExecutions(executions);
            build = model.getBuild();
            if (build == null) {
                build = new Build();
                model.setBuild(build);
            }
            model.getBuild().addPlugin(enforcerPlugin);
        }
    }

    private void updateBuild(Model model) {
        Plugin bwMavenPlugin = new Plugin();
        bwMavenPlugin.setGroupId(this.pluginDescriptor.getGroupId());
        bwMavenPlugin.setArtifactId(this.pluginDescriptor.getArtifactId());
        bwMavenPlugin.setVersion(this.pluginDescriptor.getVersion());
        bwMavenPlugin.setExtensions(true);
        Plugin cleanPlugin = new Plugin();
        cleanPlugin.setArtifactId("maven-clean-plugin");
        cleanPlugin.setVersion("2.5");
        Xpp3Dom config = MojoExecutor.configuration((MojoExecutor.Element[])new MojoExecutor.Element[]{MojoExecutor.element((String)"skip", (String)"true")});
        cleanPlugin.setConfiguration((Object)config);
        Build build = model.getBuild();
        if (build == null) {
            build = new Build();
            model.setBuild(build);
        }
        model.getBuild().setOutputDirectory(".");
        model.getBuild().addPlugin(bwMavenPlugin);
        model.getBuild().addPlugin(cleanPlugin);
    }

    private void generateDeployPOM(MavenProject project) throws MojoExecutionException {
        File outputFile = this.getOutputFile();
        this.getLog().info((CharSequence)("Generating deployment POM in '" + outputFile.getAbsolutePath() + "'"));
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("deploy/ear/pom.xml");
        try {
            outputFile.createNewFile();
            FileOutputStream fos = new FileOutputStream(outputFile);
            IOUtils.copy((InputStream)in, (OutputStream)fos);
        }
        catch (IOException e) {
            throw new MojoExecutionException(FAILURE_POM_DEPLOY);
        }
        try {
            Model model = POMManager.getModelFromPOM(outputFile, this.getLog());
            model.setGroupId(project.getGroupId());
            model.setArtifactId(project.getArtifactId());
            model.setVersion(project.getVersion());
            if (project.getPackaging().equals("pom")) {
                model.setArtifactId(project.getArtifactId() + this.getArtifactSuffix());
                model.setPackaging("pom");
                model.getProperties().setProperty("generate.pom.skip", "true");
                model.getProperties().setProperty("maven.deploy.skip", "true");
                model.getProperties().setProperty("maven.install.skip", "true");
                model = this.addDefaultProperties(model, project);
                this.updateBuildForPOM(model);
                model = this.addModules(model, project);
            } else if (project.getPackaging().equals("bw-ear")) {
                model.setPackaging("bw-ear-deploy");
                File rootDeployPOM = this.updateProperties(model, project);
                if (rootDeployPOM != null) {
                    File destinationFile = new File(project.getBuild().getDirectory() + File.separator + this.pomDeployFilename);
                    FileUtils.copyFile((File)rootDeployPOM, (File)destinationFile);
                    this.getLog().debug((CharSequence)("Copying deployment POM '" + rootDeployPOM.getAbsolutePath() + "' to: " + destinationFile.getAbsolutePath()));
                }
                this.updateBuild(model);
                model = this.addParent(model, this.parentGroupId, this.parentArtifactId + this.getArtifactSuffix(), this.parentVersion);
            }
            POMManager.writeModelToPOM(model, outputFile, this.getLog());
            if (project.getPackaging().equals("pom") && model.getGroupId().equals(this.parentGroupId) && model.getArtifactId().equals(this.parentArtifactId + this.getArtifactSuffix())) {
                this.copyToModules(outputFile, model, project);
            }
            this.attachFile(outputFile, "pom", "deploy");
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private String getArtifactSuffix() {
        if (this.parentArtifactSuffix != null && !this.parentArtifactSuffix.isEmpty()) {
            if (this.parentArtifactSuffix.startsWith("-")) {
                return this.parentArtifactSuffix;
            }
            return "-" + this.parentArtifactSuffix;
        }
        return "";
    }

    private void addDefaultProperty(Model model, Properties properties, String propertyName) {
        String propertyValue = (String)properties.get(propertyName);
        if (propertyValue != null) {
            model.getProperties().setProperty(propertyName, propertyValue);
        }
    }

    private Properties getOriginalProperties(MavenProject project) {
        if (project == null) {
            return new Properties();
        }
        Properties result = this.getOriginalProperties(project.getParent());
        result.putAll((Map<?, ?>)project.getOriginalModel().getProperties());
        return result;
    }

    private Model addDefaultProperties(Model model, MavenProject project) {
        Properties properties = this.getOriginalProperties(project);
        this.deployProperties.add("appmanage.path");
        this.deployProperties.add("appmanage.tra.path");
        this.deployProperties.add("bwengine.path");
        this.deployProperties.add("bwengine.tra.path");
        this.deployProperties.add("deploy.contact");
        this.deployProperties.add("deploy.description");
        this.deployProperties.add("deploy.maxDeploymentRevision");
        this.deployProperties.add("deploy.project.name");
        this.deployProperties.add("project.build.sourceEncoding");
        this.deployProperties.add("project.package.directory");
        this.deployProperties.add("tibrv.home.path");
        model.getProperties().setProperty("externalPropertiesFile", "OverrideThis");
        for (String deployProperty : this.deployProperties) {
            this.addDefaultProperty(model, properties, deployProperty);
        }
        return model;
    }

    @Override
    public void execute() throws MojoExecutionException {
        Boolean skipParent = super.skip();
        if (skipParent.booleanValue() || this.skipGeneratePom) {
            File outputFile;
            if (!skipParent.booleanValue()) {
                this.getLog().info((CharSequence)"Skipping.");
            }
            if ((outputFile = this.getOutputFile()) != null && !outputFile.exists() && this.touchPOMDeployIfSkipped.booleanValue()) {
                try {
                    outputFile.getParentFile().mkdirs();
                    outputFile.createNewFile();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
                }
            }
            if (outputFile != null && outputFile.exists()) {
                this.attachFile(outputFile, "pom", "deploy");
            } else {
                this.getLog().warn((CharSequence)"Could not attach artifact.");
            }
            return;
        }
        if (!this.packageDirectory.exists()) {
            this.packageDirectory.mkdirs();
        }
        if (this.excludedModules == null) {
            this.excludedModules = new ArrayList<String>();
        }
        if (this.includedModules == null) {
            this.includedModules = new ArrayList<String>();
        }
        if (this.deployProperties == null) {
            this.deployProperties = new ArrayList<String>();
        }
        MavenProject project = this.getProject();
        if (this.useParent) {
            MavenProject parent = this.getProject().getParent();
            if (parent != null) {
                project = parent;
            } else {
                this.getLog().warn((CharSequence)WARN_NO_PARENT);
            }
        }
        this.generateDeployPOM(project);
    }
}

