/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.packaging;

import fr.fastconnect.factory.tibco.bw.maven.packaging.AbstractPackagingMojo;
import fr.fastconnect.factory.tibco.bw.maven.packaging.ApplicationManagement;
import java.util.Properties;
import javax.xml.bind.JAXBException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="generate-properties-from-xml", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class GeneratePropertiesFromXMLMojo
extends AbstractPackagingMojo {
    protected static final String XML_LOAD_SUCCESS = "Successfully loaded properties from XML file";
    protected static final String XML_LOAD_FAILURE = "Failed to load properties from XML file";
    protected static final String PROPERTIES_SAVE_SERVICES_SUCCESS = "Successfully saved properties to file";
    protected static final String PROPERTIES_SAVE_SERVICES_FAILURE = "Failed to save properties to XML file";
    protected static final String PROPERTIES_SAVE_GVS_SUCCESS = "Successfully saved properties to file";
    protected static final String PROPERTIES_SAVE_GVS_FAILURE = "Failed to save properties to XML file";

    @Override
    protected String getArtifactFileExtension() {
        return ".properties";
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (super.skip()) {
            return;
        }
        Properties earGlobalVariables = new Properties();
        Properties earServices = new Properties();
        try {
            ApplicationManagement application = new ApplicationManagement(this.deploymentDescriptor);
            earGlobalVariables = application.getGlobalVariables();
            earServices = application.getServices();
            this.getLog().info((CharSequence)("Successfully loaded properties from XML file '" + this.deploymentDescriptor + "'"));
        }
        catch (JAXBException e) {
            throw new MojoExecutionException("Failed to load properties from XML file '" + this.deploymentDescriptor + "'", (Exception)((Object)e));
        }
        this.savePropertiesToFile(this.deploymentGlobalVariables, earGlobalVariables, "Global Variables", "Successfully saved properties to file", "Failed to save properties to XML file");
        this.savePropertiesToFile(this.deploymentServices, earServices, "Services (Bindings, Processes)", "Successfully saved properties to file", "Failed to save properties to XML file");
    }
}

