/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.packaging;

import com.tibco.xmlns.applicationmanagement.EncodingType;
import com.tibco.xmlns.applicationmanagement.Events;
import com.tibco.xmlns.applicationmanagement.HttpRepoInstance;
import com.tibco.xmlns.applicationmanagement.LocalRepoInstance;
import com.tibco.xmlns.applicationmanagement.RepoInstances;
import com.tibco.xmlns.applicationmanagement.RepoType;
import com.tibco.xmlns.applicationmanagement.RvRepoInstance;
import fr.fastconnect.factory.tibco.bw.maven.packaging.AbstractPackagingMojo;
import fr.fastconnect.factory.tibco.bw.maven.packaging.ApplicationManagement;
import fr.fastconnect.factory.tibco.bw.maven.packaging.monitoring.FailureEvent;
import fr.fastconnect.factory.tibco.bw.maven.packaging.monitoring.LogEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="generate-xml-from-properties", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class GenerateXMLFromPropertiesMojo
extends AbstractPackagingMojo {
    protected static final String FLAT_PATH_SEPARATOR = "/";
    protected static final String APPLICATION_MANAGEMENT_COPY_FAILURE = "Failed to copy the Application Management file from";
    protected static final String APPLICATION_MANAGEMENT_LOAD_FAILURE = "Failed to load the Application Management file in";
    protected static final String PROPERTIES_GLOBAL_VARIABLES_LOAD_FAILURE = "Failed to load the Global Variables Properties file in";
    protected static final String PROPERTIES_SERVICES_LOAD_FAILURE = "Failed to load the Services Properties file in";
    protected static final String APPLICATION_MANAGEMENT_MERGE_FAILURE = "Failed to merge the Properties files in the Application Management file";
    protected static final String APPLICATION_MANAGEMENT_MERGE_SUCCESS = "Successfully merged the Properties in the final XML Deployment Descriptor in";
    private ApplicationManagement application;

    @Override
    protected String getArtifactFileExtension() {
        return ".xml";
    }

    private void init() throws MojoExecutionException {
        try {
            FileUtils.copyFile((File)this.deploymentDescriptor, (File)this.deploymentDescriptorFinal);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy the Application Management file from '" + this.deploymentDescriptor + "' to '" + this.deploymentDescriptorFinal + "'", (Exception)e);
        }
        try {
            this.application = new ApplicationManagement(this.deploymentDescriptorFinal);
        }
        catch (JAXBException e) {
            throw new MojoExecutionException("Failed to load the Application Management file in '" + this.deploymentDescriptorFinal + "'", (Exception)((Object)e));
        }
    }

    private void mergeGlobalVariables() throws MojoExecutionException {
        Properties propertiesGlobalVariables;
        try {
            propertiesGlobalVariables = this.loadPropertiesFile(this.deploymentGlobalVariables);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load the Global Variables Properties file in '" + this.deploymentGlobalVariables + "'", e);
        }
        Enumeration<Object> e = propertiesGlobalVariables.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = propertiesGlobalVariables.getProperty(key);
            this.application.setGlobalVariable(key, value);
        }
    }

    private void mergeServices() throws MojoExecutionException {
        Properties propertiesServices;
        try {
            propertiesServices = this.loadPropertiesFile(this.deploymentServices);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to load the Services Properties file in '" + this.deploymentServices + "'", e);
        }
        Pattern patternElements = Pattern.compile("(\\w+(\\[[\\w -\\.\\/?]*\\])?)+");
        Enumeration<Object> e = propertiesServices.keys();
        block4: while (e.hasMoreElements()) {
            Matcher matcherElements;
            String currentPath = "";
            String key = (String)e.nextElement();
            String value = propertiesServices.getProperty(key);
            Object parent = null;
            while ((matcherElements = patternElements.matcher(key)).find()) {
                String element = matcherElements.group();
                currentPath = currentPath + FLAT_PATH_SEPARATOR + element;
                parent = this.application.getElement(currentPath, element, value, parent);
                if (key.equals(element)) continue block4;
                key = key.substring(element.length() + 1);
            }
        }
        try {
            this.application.removeDefaultBindingIfNotExists(this.loadPropertiesFile(this.deploymentServices));
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Failed to load the Services Properties file in '" + this.deploymentServices + "'", ex);
        }
        this.application.removeDuplicateBinding();
    }

    private void updateRepoInstances() {
        RepoType repoType;
        EncodingType encoding;
        RepoInstances repoInstances = this.application.getRepoInstances();
        RvRepoInstance rvRepoInstance = repoInstances.getRvRepoInstance();
        rvRepoInstance.setDiscoveryTimout(BigInteger.valueOf(this.repoRvDiscoveryTimeout.intValue()));
        rvRepoInstance.setTimeout(BigInteger.valueOf(this.repoRvTimeout.intValue()));
        rvRepoInstance.setDaemon(this.repoRvDaemon);
        rvRepoInstance.setService(this.repoRvService);
        rvRepoInstance.setNetwork(this.repoRvNetwork);
        rvRepoInstance.setRegionalSubject(this.repoRvRegionalSubject);
        rvRepoInstance.setOperationRetry(BigInteger.valueOf(this.repoRvOperationRetry.intValue()));
        rvRepoInstance.setExtraPropertyFile(this.repoRvExtraPropertyFile);
        rvRepoInstance.setServer(this.repoRvServer);
        rvRepoInstance.setUser(this.repoRvUser);
        rvRepoInstance.setPassword(this.repoRvPassword);
        HttpRepoInstance httpRepoInstance = repoInstances.getHttpRepoInstance();
        httpRepoInstance.setTimeout(BigInteger.valueOf(this.repoHttpTimeout.intValue()));
        httpRepoInstance.setUrl(this.repoHttpUrl);
        httpRepoInstance.setServer(this.repoHttpServer);
        httpRepoInstance.setUser(this.repoHttpUser);
        httpRepoInstance.setPassword(this.repoHttpPassword);
        httpRepoInstance.setExtraPropertyFile(this.repoHttpExtraPropertyFile);
        LocalRepoInstance localRepoInstance = repoInstances.getLocalRepoInstance();
        try {
            encoding = EncodingType.valueOf((String)this.repoLocalEncoding);
        }
        catch (IllegalArgumentException e) {
            encoding = EncodingType.UTF_8;
        }
        localRepoInstance.setEncoding(encoding);
        repoInstances.setRvRepoInstance(rvRepoInstance);
        repoInstances.setHttpRepoInstance(httpRepoInstance);
        repoInstances.setLocalRepoInstance(localRepoInstance);
        try {
            repoType = RepoType.valueOf((String)this.repoSelectInstance.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            repoType = RepoType.LOCAL;
        }
        repoInstances.setSelected(repoType);
    }

    private void updateMonitoringRules() {
        Events events = this.createMonitoringEvents();
        this.application.addMonitoringEventsToAllServices(events);
    }

    private void updateAdditionalInfo() {
        this.getLog().debug((CharSequence)"Updating additional information...");
        this.getLog().debug((CharSequence)("MaxDeploymentRevision: " + this.maxDeploymentRevision));
        this.getLog().debug((CharSequence)("Contact: " + this.contact));
        this.getLog().debug((CharSequence)("Description: " + this.description));
        this.application.setMaxDeploymentRevision(this.maxDeploymentRevision);
        this.application.setContact(this.contact);
        this.application.setDescription(this.description);
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (super.skip()) {
            if (this.deploymentDescriptorFinal != null && !this.deploymentDescriptorFinal.exists() && this.touchFinalDeploymentDescriptorIfSkipped.booleanValue()) {
                try {
                    this.deploymentDescriptorFinal.getParentFile().mkdirs();
                    this.deploymentDescriptorFinal.createNewFile();
                }
                catch (IOException e) {
                    throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
                }
            }
            if (this.deploymentDescriptorFinal != null && this.deploymentDescriptorFinal.exists()) {
                this.attachFile(this.deploymentDescriptorFinal, "xml", "final");
            } else {
                this.getLog().warn((CharSequence)"Could not attach artifact.");
            }
            return;
        }
        this.init();
        this.mergeGlobalVariables();
        this.mergeServices();
        this.updateRepoInstances();
        this.updateMonitoringRules();
        this.updateAdditionalInfo();
        try {
            this.application.save();
        }
        catch (JAXBException e) {
            throw new MojoExecutionException("Failed to merge the Properties files in the Application Management file '" + this.deploymentServices + "'", (Exception)((Object)e));
        }
        this.attachFile(this.deploymentDescriptorFinal, "xml", "final");
        this.getLog().info((CharSequence)("Successfully merged the Properties in the final XML Deployment Descriptor in '" + this.deploymentDescriptorFinal + "'"));
    }

    private Events createMonitoringEvents() {
        Events result = new Events();
        if (this.events != null) {
            List<LogEvent> logs;
            List<FailureEvent> failures = this.events.getFailures();
            if (failures != null) {
                for (FailureEvent failureEvent : failures) {
                    ApplicationManagement.addEvent(result, failureEvent);
                }
            }
            if ((logs = this.events.getLogs()) != null) {
                for (LogEvent logEvent : logs) {
                    ApplicationManagement.addEvent(result, logEvent);
                }
            }
        }
        return result;
    }
}

