/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.packaging;

import fr.fastconnect.factory.tibco.bw.maven.packaging.AbstractPackagingMojo;
import fr.fastconnect.factory.tibco.bw.maven.packaging.ApplicationManagement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="merge-properties", defaultPhase=LifecyclePhase.PREPARE_PACKAGE)
public class MergePropertiesMojo
extends AbstractPackagingMojo {
    @Parameter(property="alwaysKeepEmptyBindings", defaultValue="false")
    boolean alwaysKeepEmptyBindings;
    @Parameter(property="ignorePropertiesMerge", defaultValue="false")
    boolean ignorePropertiesMerge;
    @Parameter(property="mergeCommonLast", defaultValue="false")
    boolean mergeCommonLast;
    protected static final String MERGING_PROPERTIES = "Merging properties...";
    protected static final String NOTHING_TO_MERGE = "Nothing to merge.";
    protected static final String MERGE_FAILURE = "Failed to merge properties";
    protected static final String PROPERTIES_LOAD_FAILURE = "Failed to load properties";
    protected static final String PROPERTIES_SAVE_GVS_SUCCESS = "Successfully saved merged properties to file";
    protected static final String PROPERTIES_SAVE_GVS_FAILURE = "Failed to save merged properties to XML file";
    protected static final String PROPERTIES_SAVE_SERVICES_SUCCESS = "Successfully saved merged properties to file";
    protected static final String PROPERTIES_SAVE_SERVICES_FAILURE = "Failed to save merged properties to XML file";
    protected static final String USING_GVS_COMMON_FILE = "Using Global Variables common properties file";
    protected static final String USING_GVS_REFERENCE_FILE = "Using Global Variables reference properties file";
    protected static final String USING_SERVICES_COMMON_FILE = "Using Services common properties file";
    protected static final String USING_SERVICES_REFERENCE_FILE = "Using Services reference properties file";
    private List<ImmutablePair<String, String>> pairParInstance = new ArrayList<ImmutablePair<String, String>>();
    private static final String regexNotEmptyBinding = "^bw\\[(.*)\\]/bindings/binding\\[(.+)\\]/(.*)$";
    private static final String regexEmptyBinding = "^bw\\[(.*)\\]/bindings/binding(\\[\\])/(.*)$";

    @Override
    protected String getArtifactFileExtension() {
        return ".properties";
    }

    public MergedFiles mergeFiles(Properties propertiesGlobalVariables, Properties propertiesServices, File deploymentGlobalVariables, File deploymentServices, String messageGlobalVariables, String messageServices) throws MojoExecutionException, IOException {
        MergedFiles result = MergedFiles.NONE;
        if (deploymentGlobalVariables != null && deploymentGlobalVariables.exists() && !deploymentGlobalVariables.getCanonicalPath().equals(this.deploymentGlobalVariables.getCanonicalPath())) {
            Properties propertiesGlobalVariablesReference;
            this.getLog().info((CharSequence)(messageGlobalVariables + " : " + deploymentGlobalVariables.getAbsolutePath()));
            try {
                propertiesGlobalVariablesReference = this.loadPropertiesFile(deploymentGlobalVariables);
            }
            catch (Exception e) {
                throw new MojoExecutionException(PROPERTIES_LOAD_FAILURE, e);
            }
            Enumeration<Object> e = propertiesGlobalVariablesReference.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = propertiesGlobalVariablesReference.getProperty(key);
                propertiesGlobalVariables.setProperty(key, value);
            }
            result = MergedFiles.GV;
        }
        Pattern pNotEmptyBinding = Pattern.compile(regexNotEmptyBinding);
        if (deploymentServices != null && deploymentServices.exists() && !deploymentServices.getCanonicalPath().equals(this.deploymentServices.getCanonicalPath())) {
            Properties propertiesServicesReference;
            this.getLog().info((CharSequence)(messageServices + " : " + deploymentServices.getAbsolutePath()));
            try {
                propertiesServicesReference = this.loadPropertiesFile(deploymentServices);
            }
            catch (Exception e) {
                throw new MojoExecutionException(PROPERTIES_LOAD_FAILURE, e);
            }
            Enumeration<Object> e = propertiesServicesReference.keys();
            while (e.hasMoreElements()) {
                String binding;
                String par;
                ImmutablePair pair;
                String key = (String)e.nextElement();
                Matcher mNotEmptyBinding = pNotEmptyBinding.matcher(key);
                if (mNotEmptyBinding.matches() && !this.isAWildCard(key) && !this.pairParInstance.contains(pair = new ImmutablePair((Object)(par = mNotEmptyBinding.group(1)), (Object)(binding = mNotEmptyBinding.group(2))))) {
                    propertiesServices = this.duplicateEmptyBinding(propertiesServices, par, binding);
                    this.pairParInstance.add((ImmutablePair<String, String>)pair);
                }
                String value = propertiesServicesReference.getProperty(key);
                propertiesServices.setProperty(key, value);
            }
            propertiesServices = this.expandWildCards(propertiesServices);
            result = result == MergedFiles.GV ? MergedFiles.BOTH : MergedFiles.SERVICES;
        }
        return result;
    }

    private Properties duplicateEmptyBinding(Properties properties, String par, String binding) {
        Pattern pEmptyBinding = Pattern.compile(regexEmptyBinding);
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = properties.getProperty(key);
            Matcher mEmptyBinding = pEmptyBinding.matcher(key);
            if (mEmptyBinding.matches() && mEmptyBinding.group(1).equals(par)) {
                key = "bw[" + mEmptyBinding.group(1) + "]/bindings/binding[" + binding + "]/" + mEmptyBinding.group(3);
            }
            properties.setProperty(key, value);
        }
        return properties;
    }

    private Properties sortProperties(Properties properties) throws ConfigurationException, IOException {
        ApplicationManagement.SortedProperties sp = new ApplicationManagement.SortedProperties();
        sp.putAll((Map<?, ?>)properties);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        sp.store(baos, null);
        properties.clear();
        properties.load(new ByteArrayInputStream(baos.toByteArray()));
        return properties;
    }

    protected boolean isAWildCard(String key) {
        String regexVariable = "bw\\[.*\\]/variables\\[.*\\]/variable\\[.*\\]";
        return key.contains("*") && !Pattern.matches(regexVariable, key);
    }

    protected Properties expandWildCards(Properties properties) {
        String key;
        Properties propertiesWithWildCards = new Properties(){
            private static final long serialVersionUID = 7793482336210629858L;

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(super.keySet()));
            }
        };
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            if (!this.isAWildCard(key)) continue;
            propertiesWithWildCards.setProperty(key, properties.getProperty(key));
            properties.remove(key);
        }
        Enumeration<Object> w = propertiesWithWildCards.keys();
        while (w.hasMoreElements()) {
            String keyWithWildCards = (String)w.nextElement();
            String regex = MergePropertiesMojo.wildcardToRegex(keyWithWildCards);
            Boolean found = false;
            e = properties.keys();
            while (e.hasMoreElements()) {
                key = (String)e.nextElement();
                if (!Pattern.matches(regex, key)) continue;
                found = true;
                String value = propertiesWithWildCards.getProperty(keyWithWildCards);
                properties.setProperty(key, value);
            }
            if (found.booleanValue()) continue;
            properties.setProperty(keyWithWildCards, propertiesWithWildCards.getProperty(keyWithWildCards));
        }
        return properties;
    }

    protected Properties removeWildCards(Properties properties) {
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!this.isAWildCard(key)) continue;
            properties.remove(key);
        }
        return properties;
    }

    @Override
    public void execute() throws MojoExecutionException {
        if (super.skip()) {
            return;
        }
        if (this.ignorePropertiesMerge) {
            return;
        }
        this.getLog().info((CharSequence)MERGING_PROPERTIES);
        try {
            Properties earGlobalVariables = this.loadPropertiesFile(this.deploymentGlobalVariables);
            Properties earServices = this.loadPropertiesFile(this.deploymentServices);
            MergedFiles mergedCommonFiles = MergedFiles.NONE;
            MergedFiles mergedReferenceFiles = MergedFiles.NONE;
            if (this.mergeCommonLast) {
                if (!this.ignoreReferenceFiles) {
                    mergedReferenceFiles = this.mergeFiles(earGlobalVariables, earServices, this.deploymentGlobalVariablesReference, this.deploymentServicesReference, USING_GVS_REFERENCE_FILE, USING_SERVICES_REFERENCE_FILE);
                }
                if (!this.ignoreCommonFiles) {
                    mergedCommonFiles = this.mergeFiles(earGlobalVariables, earServices, this.deploymentGlobalVariablesCommon, this.deploymentServicesCommon, USING_GVS_COMMON_FILE, USING_SERVICES_COMMON_FILE);
                }
            } else {
                if (!this.ignoreCommonFiles) {
                    mergedCommonFiles = this.mergeFiles(earGlobalVariables, earServices, this.deploymentGlobalVariablesCommon, this.deploymentServicesCommon, USING_GVS_COMMON_FILE, USING_SERVICES_COMMON_FILE);
                }
                if (!this.ignoreReferenceFiles) {
                    mergedReferenceFiles = this.mergeFiles(earGlobalVariables, earServices, this.deploymentGlobalVariablesReference, this.deploymentServicesReference, USING_GVS_REFERENCE_FILE, USING_SERVICES_REFERENCE_FILE);
                }
            }
            earGlobalVariables = this.sortProperties(earGlobalVariables);
            earServices = this.sortProperties(earServices);
            earServices = this.removeWildCards(earServices);
            if (!this.alwaysKeepEmptyBindings) {
                earServices = this.removeEmptyBindings(earServices);
            }
            if (mergedCommonFiles == MergedFiles.GV || mergedCommonFiles == MergedFiles.BOTH || mergedReferenceFiles == MergedFiles.GV || mergedReferenceFiles == MergedFiles.BOTH || mergedCommonFiles == MergedFiles.SERVICES || mergedCommonFiles == MergedFiles.BOTH || mergedReferenceFiles == MergedFiles.SERVICES || mergedReferenceFiles == MergedFiles.BOTH) {
                this.getLog().info((CharSequence)"");
            } else {
                this.getLog().debug((CharSequence)("GV ref: " + this.deploymentGlobalVariablesReference.getAbsolutePath()));
                this.getLog().debug((CharSequence)("SVC ref: " + this.deploymentServicesReference.getAbsolutePath()));
                this.getLog().debug((CharSequence)("GV common: " + this.deploymentGlobalVariablesCommon.getAbsolutePath()));
                this.getLog().debug((CharSequence)("SVC common: " + this.deploymentServicesCommon.getAbsolutePath()));
                this.getLog().info((CharSequence)NOTHING_TO_MERGE);
            }
            if (mergedCommonFiles == MergedFiles.GV || mergedCommonFiles == MergedFiles.BOTH || mergedReferenceFiles == MergedFiles.GV || mergedReferenceFiles == MergedFiles.BOTH) {
                this.savePropertiesToFile(this.deploymentGlobalVariables, earGlobalVariables, "Global Variables", "Successfully saved merged properties to file", "Failed to save merged properties to XML file");
            }
            if (mergedCommonFiles == MergedFiles.SERVICES || mergedCommonFiles == MergedFiles.BOTH || mergedReferenceFiles == MergedFiles.SERVICES || mergedReferenceFiles == MergedFiles.BOTH) {
                this.savePropertiesToFile(this.deploymentServices, earServices, "Services (Bindings, Processes)", "Successfully saved merged properties to file", "Failed to save merged properties to XML file");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException(MERGE_FAILURE, e);
        }
    }

    private Properties removeEmptyBindings(Properties properties) {
        String parName;
        String key;
        ArrayList<String> pars = new ArrayList<String>();
        Pattern pNotEmptyBinding = Pattern.compile(regexNotEmptyBinding);
        Pattern pEmptyBinding = Pattern.compile(regexEmptyBinding);
        Enumeration<Object> e = properties.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            Matcher mNotEmptyBinding = pNotEmptyBinding.matcher(key);
            if (!mNotEmptyBinding.matches() || pars.contains(parName = mNotEmptyBinding.group(1))) continue;
            pars.add(parName);
        }
        e = properties.keys();
        while (e.hasMoreElements()) {
            key = (String)e.nextElement();
            Matcher mEmptyBinding = pEmptyBinding.matcher(key);
            if (!mEmptyBinding.matches() || !pars.contains(parName = mEmptyBinding.group(1))) continue;
            properties.remove(key);
        }
        return properties;
    }

    private static enum MergedFiles {
        NONE,
        GV,
        SERVICES,
        BOTH;

    }
}

