/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.run;

import fr.fastconnect.factory.tibco.bw.maven.AbstractBWMojo;
import fr.fastconnect.factory.tibco.bw.maven.packaging.ApplicationManagement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="launch-designer", defaultPhase=LifecyclePhase.PROCESS_TEST_RESOURCES)
@Execute(phase=LifecyclePhase.PROCESS_TEST_RESOURCES)
public class LaunchDesignerMojo
extends AbstractBWMojo {
    protected static final String LAUNCH_DESIGNER_FAILED = "The launch of the TIBCO Designer has failed.";
    protected static final String LAUNCHING_DESIGNER = "Launching TIBCO Designer...";
    protected static final String PROJECT_LOCATION = "Project location : ";
    @Parameter(property="bw.project.use.copy", required=false, defaultValue="false")
    protected Boolean useBuildSrcDirectory;
    @Parameter(property="bw.project.adapt.aliases", required=false, defaultValue="true")
    protected Boolean adaptAliases;

    private void copyDesignTimeLibs() throws IOException {
        FileUtils.copyFile((File)new File(this.testSrcDirectory + "/" + ".designtimelibs"), (File)new File(this.projectDirectory + "/" + ".designtimelibs"));
    }

    private void launchDesigner() throws MojoExecutionException, IOException {
        this.checkDesigner();
        this.copyDesignTimeLibs();
        ArrayList<String> arguments = new ArrayList<String>();
        if (this.useBuildSrcDirectory.booleanValue()) {
            arguments.add(this.buildSrcDirectory.getAbsolutePath());
            this.getLog().info((CharSequence)(PROJECT_LOCATION + this.buildSrcDirectory.getAbsolutePath()));
        } else {
            arguments.add(this.projectDirectory.getAbsolutePath());
            this.getLog().info((CharSequence)(PROJECT_LOCATION + this.projectDirectory.getAbsolutePath()));
        }
        this.getLog().info((CharSequence)LAUNCHING_DESIGNER);
        ArrayList<File> tras = new ArrayList<File>();
        tras.add(this.tibcoDesignerTRAPath);
        this.launchTIBCOBinary(this.tibcoDesignerPath, tras, arguments, this.directory, LAUNCH_DESIGNER_FAILED, true, false);
    }

    @Override
    public void execute() throws MojoExecutionException {
        this.enableTestScope();
        super.execute();
        if (this.adaptAliases.booleanValue()) {
            try {
                this.updateAliasesFile();
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getLocalizedMessage(), (Exception)e);
            }
        }
        try {
            this.launchDesigner();
        }
        catch (IOException e) {
            throw new MojoExecutionException(LAUNCH_DESIGNER_FAILED, (Exception)e);
        }
    }

    private void updateAliasesFile() throws IOException {
        String value;
        String key;
        File aliasesFile = this.getAliasesFile();
        File designer5Prefs = this.getDesigner5Prefs();
        ApplicationManagement.SortedProperties prefs = new ApplicationManagement.SortedProperties();
        FileInputStream fisPrefs = new FileInputStream(designer5Prefs);
        prefs.load(fisPrefs);
        fisPrefs.close();
        Integer maxFileAliasPref = 0;
        for (Object k : prefs.keySet()) {
            String key2 = (String)k;
            if (!key2.startsWith("filealias.pref.")) continue;
            Integer n = maxFileAliasPref;
            maxFileAliasPref = maxFileAliasPref + 1;
            Iterator<Object> iterator = maxFileAliasPref;
        }
        Properties aliases = new Properties();
        FileInputStream fis = new FileInputStream(aliasesFile);
        aliases.load(fis);
        fis.close();
        String projectVersion = this.getProject().getVersion();
        Properties duplicates = new Properties();
        for (Object e : aliases.keySet()) {
            key = (String)e;
            value = aliases.getProperty(key);
            if (!key.contains(projectVersion) || !key.endsWith(":jar")) continue;
            this.getLog().debug((CharSequence)key);
            key = key.replace(projectVersion, "${project.version}");
            duplicates.put(key, value);
        }
        if (!duplicates.isEmpty()) {
            for (Object object : duplicates.keySet()) {
                key = (String)object;
                value = duplicates.getProperty(key);
                key = key.replace("tibco.alias.", "");
                prefs.put("filealias.pref." + maxFileAliasPref.toString(), key + "=" + value);
                Integer n = maxFileAliasPref;
                Integer n2 = maxFileAliasPref = Integer.valueOf(maxFileAliasPref + 1);
            }
            FileOutputStream fosPrefs = new FileOutputStream(designer5Prefs);
            prefs.store(fosPrefs, "");
            fis.close();
            aliases.putAll((Map<?, ?>)duplicates);
            FileOutputStream fileOutputStream = new FileOutputStream(aliasesFile);
            aliases.store(fileOutputStream, "");
            fis.close();
        }
    }
}

