/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.source;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public abstract class AbstractProjectsListMojo
extends AbstractMojo {
    protected static final String PROJECT_FOUND = " project was found.";
    protected static final String PROJECTS_FOUND = " projects were found.";
    protected static final String NOTHING_WAS_PERFORMED = "No action was performed. Add '-DdoIt=true' to perform.";
    @Parameter(property="doIt", required=true, defaultValue="false")
    protected boolean doIt;
    @Parameter(property="recursive", required=false, defaultValue="true")
    protected boolean recursive;
    @Parameter(property="patterns")
    protected List<String> patterns;
    @Parameter(property="display.list", defaultValue="true")
    protected boolean displayList;
    @Parameter(required=false, property="workspaceRoot", defaultValue="${basedir}")
    protected File workspaceRoot;
    protected List<AbstractProject> projects;
    protected FileSet restriction;
    protected int successfullyPerformedAction;

    public static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].equals(base[commonIndex]); ++commonIndex) {
            common.append(target[commonIndex] + pathSeparator);
        }
        if (commonIndex == 0) {
            throw new PathResolutionException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuffer relative = new StringBuffer();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }

    private static String toCommaSeparatedString(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String string : strings) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(string);
        }
        return sb.toString();
    }

    public static List<File> toFileList(FileSet fileSet) throws IOException {
        File directory = new File(fileSet.getDirectory());
        String includes = AbstractProjectsListMojo.toCommaSeparatedString(fileSet.getIncludes());
        String excludes = AbstractProjectsListMojo.toCommaSeparatedString(fileSet.getExcludes());
        return FileUtils.getFiles((File)directory, (String)includes, (String)excludes);
    }

    protected abstract void displayProject(AbstractProject var1);

    protected boolean performAction(AbstractProject p) {
        return true;
    }

    protected abstract void initProjects() throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, XmlPullParserException;

    protected final void initProjects(String mandatoryFilename, HashMap<String, String> m, Class<? extends AbstractProject> classAbstractProject) throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, SecurityException, NoSuchMethodException, XmlPullParserException {
        this.projects = new ArrayList<AbstractProject>();
        this.restriction = new FileSet();
        this.restriction.setDirectory(this.workspaceRoot.getAbsolutePath());
        if (this.recursive) {
            for (String p : this.patterns) {
                this.restriction.addInclude(p + mandatoryFilename);
            }
        } else {
            this.restriction.addInclude(mandatoryFilename);
        }
        this.restriction.addExclude("**/target/**/" + mandatoryFilename);
        this.restriction.addExclude("**/bin/" + mandatoryFilename);
        List<File> files = AbstractProjectsListMojo.toFileList(this.restriction);
        for (File f : files) {
            Constructor<? extends AbstractProject> ctor = classAbstractProject.getConstructor(new Class[0]);
            AbstractProject ap = ctor.newInstance(new Object[0]);
            ap.initialize(f, this.workspaceRoot, m, mandatoryFilename, this.getLog());
            if (!ap.isIgnored()) {
                this.projects.add(ap);
                continue;
            }
            this.getLog().debug((CharSequence)("Ignoring project '" + ap.getProjectName() + "'"));
        }
    }

    protected void browseList() {
        for (AbstractProject p : this.projects) {
            if (this.displayList) {
                this.getLog().info((CharSequence)"---");
                this.displayProject(p);
                this.getLog().info((CharSequence)"");
            }
            if (!this.doIt || !this.performAction(p)) continue;
            ++this.successfullyPerformedAction;
        }
        this.getLog().info((CharSequence)"");
        if (this.projects.size() > 1) {
            this.getLog().info((CharSequence)(this.projects.size() + PROJECTS_FOUND));
        } else {
            this.getLog().info((CharSequence)(this.projects.size() + PROJECT_FOUND));
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.patterns == null || this.patterns.isEmpty()) {
            this.patterns = new ArrayList<String>();
            this.patterns.add("**/");
        }
        if (this.recursive) {
            this.getLog().info((CharSequence)("Scanning recursively '" + this.workspaceRoot + "' with patterns '" + this.patterns.toString() + "'"));
        } else {
            this.getLog().info((CharSequence)("Scanning '" + this.workspaceRoot + "'"));
        }
        this.successfullyPerformedAction = 0;
        try {
            this.initProjects();
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getLocalizedMessage(), e);
        }
        this.browseList();
    }

    static class PathResolutionException
    extends RuntimeException {
        private static final long serialVersionUID = 2723212952556555691L;

        PathResolutionException(String msg) {
            super(msg);
        }
    }

    public static abstract class AbstractProject {
        protected Log logger;
        private String mandatoryFilename;
        private File path;
        protected File root;

        public void initialize(File path, File root, HashMap<String, String> m, String mandatoryFilename, Log logger) throws IOException, XmlPullParserException {
            this.logger = logger;
            this.mandatoryFilename = mandatoryFilename;
            this.path = path;
            this.root = root;
        }

        public String getAbsolutePath() {
            return this.root + File.separator + this.getRelativePath();
        }

        public String getOriginalAbsolutePath() {
            return this.root + File.separator + this.getOriginalRelativePath();
        }

        public String getMandatoryFilePath() {
            return this.getOriginalAbsolutePath() + File.separator + this.mandatoryFilename;
        }

        public String getMandatoryFilePath(String customMandatoryFilename) {
            return this.getOriginalAbsolutePath() + File.separator + customMandatoryFilename;
        }

        private String _getRelativePath() {
            String s = this.path.getAbsolutePath();
            s = s.replace(this.root.getAbsolutePath() + File.separator, "");
            if ((s = s.replace(this.mandatoryFilename, "")).endsWith(File.separator)) {
                s = s.substring(0, s.length() - 1);
            }
            return s;
        }

        public String getOriginalRelativePath() {
            return this._getRelativePath();
        }

        public String getRelativePath() {
            return this._getRelativePath();
        }

        public boolean isIgnored() {
            return false;
        }

        public abstract String getProjectName();

        public abstract String getGroupId();

        public abstract String getArtifactId();

        public abstract String getVersion();

        public Boolean getPutPOMInParentDirectory() {
            return false;
        }
    }
}

