/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.source;

import fr.fastconnect.factory.tibco.bw.maven.source.AbstractDependencyMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.AbstractProjectsListMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.POMManager;
import java.io.File;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="add-dependency", requiresProject=false)
public class AddDependencyMojo
extends AbstractDependencyMojo {
    @Override
    protected String getActionFailure() {
        return " project failed to add the dependency.";
    }

    @Override
    protected String getActionFailures() {
        return " projects failed to add the dependency.";
    }

    @Override
    protected String getActionSuccess() {
        return " project successfully added the dependency.";
    }

    @Override
    protected String getActionSuccesses() {
        return " projects successfully added the dependency.";
    }

    @Override
    protected void displayProject(AbstractProjectsListMojo.AbstractProject p) {
        super.displayProject(p);
        Dependency d = this.createDependency();
        this.getLog().info((CharSequence)"");
        this.getLog().info((CharSequence)("Adding dependency '" + d.getManagementKey() + "' to '" + p.getProjectName() + "'"));
    }

    @Override
    protected boolean performAction(AbstractProjectsListMojo.AbstractProject p) {
        File pom = new File(p.getMandatoryFilePath());
        Dependency d = this.createDependency();
        try {
            if (!POMManager.dependencyExists(pom, d, this.getLog())) {
                if (!this.dependencyManagement) {
                    POMManager.addDependency(pom, d, this.getLog());
                } else {
                    POMManager.addDependencyManagement(pom, d, this.getLog());
                }
                return true;
            }
            this.getLog().info((CharSequence)("Skipping : '" + d.getManagementKey() + "' is already a dependency in '" + pom + "'"));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

