/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.source;

import fr.fastconnect.factory.tibco.bw.maven.source.AbstractProjectsListMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.MavenProjectsListWithRootPOMMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.POMManager;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="add-maven-projects", requiresProject=false)
public class AddProjectsAsModules
extends MavenProjectsListWithRootPOMMojo {
    @Override
    protected String getActionFailure() {
        return " project failed to be added to the root POM.";
    }

    @Override
    protected String getActionFailures() {
        return " projects failed to be added to the root POM.";
    }

    @Override
    protected String getActionSuccess() {
        return " project was successfully added to the root POM.";
    }

    @Override
    protected String getActionSuccesses() {
        return " projects were successfully added to the root POM.";
    }

    @Override
    protected boolean performAction(AbstractProjectsListMojo.AbstractProject p) {
        File tmp = new File(p.getOriginalAbsolutePath() + File.separator + "pom.xml");
        if (this.rootPOM.getAbsolutePath().equals(tmp.getAbsolutePath())) {
            return false;
        }
        String relative = AddProjectsAsModules.getRelativePath(p.getOriginalAbsolutePath(), this.rootPOM.getAbsolutePath(), File.separator);
        try {
            if (!POMManager.moduleExists(this.rootPOM, relative, this.profileId, this.getLog())) {
                this.getLog().info((CharSequence)("Adding module '" + relative + "' to '" + this.rootPOM.getAbsolutePath() + "'"));
                POMManager.addProjectAsModule(this.rootPOM, relative, this.profileId, this.getLog());
                return true;
            }
            String forProfile = "";
            if (this.profileId != null) {
                forProfile = " in profile '" + this.profileId + "'";
            }
            this.getLog().info((CharSequence)("Skipping : '" + relative + "' is already a module in '" + this.rootPOM + "'" + forProfile));
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }
}

