/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.source;

import fr.fastconnect.factory.tibco.bw.maven.InitializeMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.AbstractProjectsListMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.POMManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="list-bw-projects", requiresProject=false)
public class ExistingBWProjectsListMojo
extends AbstractProjectsListMojo {
    protected static final String MANDATORY_BW_FILENAME = "vcrepo.dat";
    @Parameter(required=false, property="putPOMInParentDirectory", defaultValue="true")
    protected Boolean putPOMInParentDirectory;
    @Parameter(required=false, property="bwProjectLocation")
    protected String bwProjectLocation;
    @Parameter(required=false, property="ignore.mavenized.projects", defaultValue="true")
    protected Boolean ignoreAlreadyMavenizedProjects;

    protected HashMap<String, String> updateProjects(HashMap<String, String> m) {
        return m;
    }

    @Override
    protected void initProjects() throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, XmlPullParserException {
        HashMap<String, String> m = new HashMap<String, String>();
        m = this.updateProjects(m);
        m.put("putPOMInParentDirectory", this.putPOMInParentDirectory.toString());
        m.put("bwProjectLocation", this.bwProjectLocation);
        m.put("ignoreAlreadyMavenizedProjects", this.ignoreAlreadyMavenizedProjects.toString());
        super.initProjects(MANDATORY_BW_FILENAME, m, BWProject.class);
    }

    protected void displayRootProject(AbstractProjectsListMojo.AbstractProject p) {
    }

    private static boolean findParentPath(File path, Model model, Log logger) throws IOException, XmlPullParserException {
        File pomPath = new File(path + File.separator + "pom.xml");
        if (pomPath != null && pomPath.exists()) {
            Model m = POMManager.getModelFromPOM(pomPath, logger);
            return InitializeMojo.hasSameGAV(model, m);
        }
        return false;
    }

    protected static File getParent(Model parentModel, File basedir, Log logger) throws IOException, XmlPullParserException {
        File result = null;
        while (basedir.getParentFile() != null && basedir.getParentFile().exists()) {
            if (ExistingBWProjectsListMojo.findParentPath(basedir.getParentFile(), parentModel, logger)) {
                result = basedir.getParentFile();
                break;
            }
            basedir = basedir.getParentFile();
        }
        return result;
    }

    @Override
    protected void displayProject(AbstractProjectsListMojo.AbstractProject p) {
        this.getLog().info((CharSequence)p.getProjectName());
        this.getLog().info((CharSequence)("  Location of the BW project    : " + p.getOriginalRelativePath()));
        this.getLog().info((CharSequence)("  Location of the project (POM) : " + p.getRelativePath()));
        this.displayRootProject(p);
        if (!((Object)((Object)this)).getClass().getName().equals(ExistingBWProjectsListMojo.class.getName())) {
            this.getLog().info((CharSequence)("  Mavenized project will be     : " + p.getGroupId() + ":" + p.getArtifactId() + ":" + p.getVersion()));
        }
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
    }

    public static class BWProject
    extends AbstractProjectsListMojo.AbstractProject {
        private Boolean putPOMInParentDirectory;
        private String bwProjectLocation;
        private String groupId;
        private String version;
        private Boolean ignoreAlreadyMavenizedProjects;

        @Override
        public void initialize(File path, File root, HashMap<String, String> m, String mandatoryFilename, Log logger) throws IOException, XmlPullParserException {
            super.initialize(path, root, m, mandatoryFilename, logger);
            this.putPOMInParentDirectory = m.get("putPOMInParentDirectory").equals("true");
            this.bwProjectLocation = this.putPOMInParentDirectory != false ? null : m.get("bwProjectLocation");
            this.groupId = m.get("groupId");
            this.version = m.get("version");
            this.ignoreAlreadyMavenizedProjects = m.get("ignoreAlreadyMavenizedProjects").equals("true");
        }

        @Override
        public Boolean getPutPOMInParentDirectory() {
            return this.putPOMInParentDirectory;
        }

        @Override
        public String getProjectName() {
            return this.getProjectName(this.getRelativePath());
        }

        @Override
        public String getRelativePath() {
            String s = super.getRelativePath();
            s = this.root + File.separator + s;
            File f = this.getRelativeProjectPath(new File(s));
            if (f != null) {
                s = f.getAbsolutePath();
            }
            s = s.replace(this.root.getAbsolutePath() + File.separator, "");
            return s;
        }

        @Override
        public String getGroupId() {
            return this.groupId;
        }

        @Override
        public String getArtifactId() {
            return this.getProjectName().replaceAll("[ _]", "-").toLowerCase();
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public boolean isIgnored() {
            File f1 = new File(this.getAbsolutePath() + File.separator + "pom.xml");
            File f2 = this.bwProjectLocation == null ? new File(this.getOriginalAbsolutePath() + File.separator + ExistingBWProjectsListMojo.MANDATORY_BW_FILENAME) : new File(this.getOriginalAbsolutePath() + File.separator + this.bwProjectLocation + File.separator + ExistingBWProjectsListMojo.MANDATORY_BW_FILENAME);
            return this.ignoreAlreadyMavenizedProjects != false && f1.exists() || !f2.exists();
        }

        private String getProjectName(String path) {
            return path.lastIndexOf(File.separator) > 1 ? path.substring(path.lastIndexOf(File.separator) + 1) : path;
        }

        private File getRelativeProjectPath(File f) {
            if (f == null) {
                return null;
            }
            File tmp = this.bwProjectLocation != null && !this.bwProjectLocation.trim().isEmpty() ? new File(f.getAbsolutePath() + this.bwProjectLocation) : new File(f.getAbsolutePath());
            if (tmp.isDirectory() && tmp.exists()) {
                if (this.putPOMInParentDirectory.booleanValue()) {
                    return f.getParentFile();
                }
                return f;
            }
            return this.getRelativeProjectPath(f.getParentFile());
        }
    }
}

