/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.source;

import fr.fastconnect.factory.tibco.bw.maven.source.AbstractProjectsListMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.ExistingBWProjectsListMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.BuildPluginManager;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="mavenize-bw-projects", requiresProject=false)
public class MassMavenizerMojo
extends ExistingBWProjectsListMojo {
    @Parameter(property="archetypeGroupId", defaultValue="fr.fastconnect.factory.tibco.bw.maven", required=false)
    protected String archetypeGroupId;
    @Parameter(property="archetypeArtifactId", defaultValue="archetype-bw-mavenizer", required=false)
    protected String archetypeArtifactId;
    @Parameter(property="archetypeVersion", required=false)
    protected String archetypeVersion;
    @Parameter(property="archetypeCatalog", required=false)
    protected String archetypeCatalog;
    @Parameter(property="archetypeRepository", required=false)
    protected String archetypeRepository;
    @Parameter(property="archetypeGoals", defaultValue="antrun:run", required=false)
    protected String archetypeGoals;
    @Parameter
    protected Properties archetypeProperties;
    @Parameter(required=false, property="isProjlib", defaultValue="false")
    protected boolean isProjlib;
    @Parameter(required=false, property="projectGroupId", defaultValue="${rootProjectGroupId}")
    protected String projectGroupId;
    @Parameter(required=false, property="projectVersion", defaultValue="1.0.0")
    protected String projectVersion;
    @Parameter(required=true, property="rootProjectGroupId")
    protected String rootProjectGroupId;
    @Parameter(required=true, property="rootProjectArtifactId")
    protected String rootProjectArtifactId;
    @Parameter(required=true, property="rootProjectVersion")
    protected String rootProjectVersion;
    protected static final String MAVENIZATION_FAILURE = " project failed the mavenization.";
    protected static final String MAVENIZATION_FAILURES = " projects failed the mavenization.";
    protected static final String MAVENIZATION_SUCCESS = " project was successfully mavenized.";
    protected static final String MAVENIZATION_SUCCESSES = " projects were successfully mavenized.";
    @Parameter(property="project", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="session", required=true, readonly=true)
    protected MavenSession session;
    @Component(role=BuildPluginManager.class)
    protected BuildPluginManager pluginManager;

    private List<MojoExecutor.Element> generateConfiguration(Properties configuration) {
        ArrayList<MojoExecutor.Element> configurations = new ArrayList<MojoExecutor.Element>();
        if (configuration != null) {
            for (Object key : configuration.keySet()) {
                String value = configuration.get(key).toString();
                this.getLog().debug((CharSequence)value);
                configurations.add(MojoExecutor.element((String)key.toString(), (String)value));
            }
        }
        return configurations;
    }

    protected MojoExecutor.ExecutionEnvironment getEnvironment() {
        return MojoExecutor.executionEnvironment((MavenProject)this.project, (MavenSession)this.session, (BuildPluginManager)this.pluginManager);
    }

    @Override
    protected boolean performAction(AbstractProjectsListMojo.AbstractProject p) {
        try {
            Properties configuration = new Properties();
            configuration.put("basedir", p.root + File.separator + p.getRelativePath());
            configuration.put("archetypeGroupId", this.archetypeGroupId);
            configuration.put("archetypeArtifactId", this.archetypeArtifactId);
            if (this.archetypeVersion != null) {
                configuration.put("archetypeVersion", this.archetypeVersion);
            }
            if (this.archetypeCatalog != null) {
                configuration.put("archetypeCatalog", this.archetypeCatalog);
            }
            if (this.archetypeRepository != null) {
                configuration.put("archetypeRepository", this.archetypeRepository);
            }
            configuration.put("goals", this.archetypeGoals);
            configuration.put("interactiveMode", (Object)false);
            this.archetypeProperties = this.initProperties(p);
            for (Object s : this.archetypeProperties.keySet()) {
                String key = (String)s;
                String value = this.archetypeProperties.getProperty(key);
                this.session.getExecutionProperties().put(key, value);
            }
            MojoExecutor.executeMojo((Plugin)MojoExecutor.plugin((String)MojoExecutor.groupId((String)"org.apache.maven.plugins"), (String)MojoExecutor.artifactId((String)"maven-archetype-plugin"), (String)MojoExecutor.version((String)"2.2")), (String)MojoExecutor.goal((String)"generate"), (Xpp3Dom)MojoExecutor.configuration((MojoExecutor.Element[])this.generateConfiguration(configuration).toArray(new MojoExecutor.Element[0])), (MojoExecutor.ExecutionEnvironment)this.getEnvironment());
        }
        catch (Exception e) {
            this.getLog().warn((CharSequence)("Mavenization failed : " + e.getLocalizedMessage()));
            return false;
        }
        return true;
    }

    @Override
    protected HashMap<String, String> updateProjects(HashMap<String, String> m) {
        assert (m != null);
        m.put("bwProjectLocation", this.bwProjectLocation);
        m.put("groupId", this.projectGroupId);
        m.put("version", this.projectVersion);
        return m;
    }

    private String getRootProjectPath(AbstractProjectsListMojo.AbstractProject p) {
        String result = "";
        Model parentModel = new Model();
        parentModel.setGroupId(this.rootProjectGroupId);
        parentModel.setArtifactId(this.rootProjectArtifactId);
        parentModel.setVersion(this.rootProjectVersion);
        parentModel.setPackaging("pom");
        try {
            File parent = MassMavenizerMojo.getParent(parentModel, new File(p.getOriginalAbsolutePath()).getParentFile(), this.getLog());
            if (parent != null) {
                result = parent.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    protected void displayRootProject(AbstractProjectsListMojo.AbstractProject p) {
        super.displayRootProject(p);
        this.getLog().info((CharSequence)("  The root project is           : " + this.rootProjectGroupId + ":" + this.rootProjectArtifactId + ":" + this.rootProjectVersion));
        this.getLog().info((CharSequence)("  The root project location is  : " + this.getRootProjectPath(p)));
    }

    private Properties initProperties(AbstractProjectsListMojo.AbstractProject p) {
        if (this.archetypeProperties == null) {
            this.archetypeProperties = new Properties();
        }
        this.archetypeProperties.put("rootProjectGroupId", this.rootProjectGroupId);
        this.archetypeProperties.put("rootProjectArtifactId", this.rootProjectArtifactId);
        this.archetypeProperties.put("rootProjectVersion", this.rootProjectVersion);
        String s = AbstractProjectsListMojo.getRelativePath(p.getAbsolutePath(), this.getRootProjectPath(p), File.separator);
        String rootRelativePath = "../..";
        for (int i = StringUtils.countMatches((CharSequence)s, (CharSequence)File.separator); i > 0; --i) {
            rootRelativePath = rootRelativePath + "/..";
        }
        this.archetypeProperties.put("rootRelativePath", rootRelativePath);
        if (this.isProjlib) {
            this.archetypeProperties.put("projectPackaging", "projlib");
        } else {
            this.archetypeProperties.put("projectPackaging", "bw-ear");
        }
        this.archetypeProperties.put("bwProjectName", p.getProjectName());
        this.archetypeProperties.put("groupId", this.projectGroupId);
        this.archetypeProperties.put("artifactId", p.getArtifactId());
        if (this.projectVersion == null || this.projectVersion.isEmpty()) {
            this.projectVersion = "[inherited]";
            this.archetypeProperties.put("versionIsInherited", "true");
        }
        this.archetypeProperties.put("version", this.projectVersion);
        if (this.bwProjectLocation == null) {
            this.bwProjectLocation = "";
            this.archetypeProperties.put("bwProjectLocationIsInherited", "true");
        }
        this.archetypeProperties.put("bwProjectLocation", this.bwProjectLocation);
        this.archetypeProperties.put("putPOMInParentDirectory", p.getPutPOMInParentDirectory().toString());
        return this.archetypeProperties;
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (!this.doIt) {
            this.getLog().info((CharSequence)"No action was performed. Add '-DdoIt=true' to perform.");
        } else if (this.projects.size() > 0) {
            int failed = this.projects.size() - this.successfullyPerformedAction;
            if (failed > 1) {
                this.getLog().info((CharSequence)(failed + MAVENIZATION_FAILURES));
            } else {
                this.getLog().info((CharSequence)(failed + MAVENIZATION_FAILURE));
            }
            if (this.successfullyPerformedAction > 1) {
                this.getLog().info((CharSequence)(this.successfullyPerformedAction + MAVENIZATION_SUCCESSES));
            } else {
                this.getLog().info((CharSequence)(this.successfullyPerformedAction + MAVENIZATION_SUCCESS));
            }
        }
    }
}

