/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.source;

import fr.fastconnect.factory.tibco.bw.maven.source.AbstractProjectsListMojo;
import fr.fastconnect.factory.tibco.bw.maven.source.POMManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

@Mojo(name="list-maven-projects", requiresProject=false)
public class MavenProjectsListMojo
extends AbstractProjectsListMojo {
    protected static final String MANDATORY_MAVEN_FILENAME = "pom.xml";

    protected String getActionFailure() {
        return " action failed.";
    }

    protected String getActionFailures() {
        return " actions failed.";
    }

    protected String getActionSuccess() {
        return " action succeeded.";
    }

    protected String getActionSuccesses() {
        return " actions succeeded.";
    }

    @Override
    protected void initProjects() throws IOException, InstantiationException, IllegalAccessException, IllegalArgumentException, SecurityException, InvocationTargetException, NoSuchMethodException, XmlPullParserException {
        super.initProjects(MANDATORY_MAVEN_FILENAME, new HashMap<String, String>(), MavenProject.class);
    }

    @Override
    protected void displayProject(AbstractProjectsListMojo.AbstractProject p) {
        this.getLog().info((CharSequence)p.getProjectName());
        this.getLog().info((CharSequence)("  Location of the project : " + p.getRelativePath()));
        this.getLog().info((CharSequence)("  Maven project is        : " + p.getGroupId() + ":" + p.getArtifactId() + ":" + p.getVersion()));
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        super.execute();
        if (!this.doIt) {
            if (!((Object)((Object)this)).getClass().getName().equals(MavenProjectsListMojo.class.getName())) {
                this.getLog().info((CharSequence)"No action was performed. Add '-DdoIt=true' to perform.");
            }
        } else if (this.projects.size() > 0) {
            int failed = this.projects.size() - this.successfullyPerformedAction;
            if (failed > 1) {
                this.getLog().info((CharSequence)(failed + this.getActionFailures()));
            } else {
                this.getLog().info((CharSequence)(failed + this.getActionFailure()));
            }
            if (this.successfullyPerformedAction > 1) {
                this.getLog().info((CharSequence)(this.successfullyPerformedAction + this.getActionSuccesses()));
            } else {
                this.getLog().info((CharSequence)(this.successfullyPerformedAction + this.getActionSuccess()));
            }
        }
    }

    public static class MavenProject
    extends AbstractProjectsListMojo.AbstractProject {
        private Model model;

        @Override
        public void initialize(File path, File root, HashMap<String, String> m, String mandatoryFilename, Log logger) throws IOException, XmlPullParserException {
            super.initialize(path, root, m, mandatoryFilename, logger);
            this.initModel();
        }

        private void initModel() throws IOException, XmlPullParserException {
            File pom = new File(this.getMandatoryFilePath());
            this.model = POMManager.getModelFromPOM(pom, this.logger);
        }

        @Override
        public String getProjectName() {
            return this.model.getName();
        }

        @Override
        public String getGroupId() {
            return this.model.getGroupId();
        }

        @Override
        public String getArtifactId() {
            return this.model.getArtifactId();
        }

        @Override
        public String getVersion() {
            return this.model.getVersion() != null ? this.model.getVersion() : "[inherited]";
        }
    }
}

