/*
 * Decompiled with CFR 0.152.
 */
package fr.fastconnect.factory.tibco.bw.maven.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class POMManager {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Model getModelFromPOM(File pom, Log logger) throws IOException, XmlPullParserException {
        Model model = null;
        FileInputStream fis = null;
        InputStreamReader isr = null;
        try {
            fis = new FileInputStream(pom);
            isr = new InputStreamReader((InputStream)fis, "utf-8");
            MavenXpp3Reader reader = new MavenXpp3Reader();
            model = reader.read((Reader)isr);
        }
        finally {
            try {
                isr.close();
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return model;
    }

    public static void writeModelToPOM(Model model, File pom, Log logger) throws IOException {
        FileOutputStream fos = new FileOutputStream(pom);
        new MavenXpp3Writer().write((OutputStream)fos, model);
        try {
            fos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void addDependency(File pom, Dependency dependency, Log logger) throws IOException, XmlPullParserException {
        Model model = POMManager.getModelFromPOM(pom, logger);
        model.addDependency(dependency);
        POMManager.writeModelToPOM(model, pom, logger);
    }

    public static void addDependencyManagement(File pom, Dependency dependency, Log logger) throws IOException, XmlPullParserException {
        Model model = POMManager.getModelFromPOM(pom, logger);
        DependencyManagement dMgmt = model.getDependencyManagement();
        if (dMgmt == null) {
            model.setDependencyManagement(new DependencyManagement());
            dMgmt = model.getDependencyManagement();
        }
        dMgmt.addDependency(dependency);
        POMManager.writeModelToPOM(model, pom, logger);
    }

    public static void removeDependency(File pom, Dependency dependency, Log logger) throws IOException, XmlPullParserException {
        Model model = POMManager.getModelFromPOM(pom, logger);
        Iterator it = model.getDependencies().iterator();
        while (it.hasNext()) {
            if (!POMManager.dependenciesEqual((Dependency)it.next(), dependency)) continue;
            it.remove();
        }
        POMManager.writeModelToPOM(model, pom, logger);
    }

    public static void removeDependencyManagement(File pom, Dependency dependency, Log logger) throws IOException, XmlPullParserException {
        Model model = POMManager.getModelFromPOM(pom, logger);
        DependencyManagement dMgmt = model.getDependencyManagement();
        if (dMgmt == null) {
            model.setDependencyManagement(new DependencyManagement());
            dMgmt = model.getDependencyManagement();
        }
        Iterator it = dMgmt.getDependencies().iterator();
        while (it.hasNext()) {
            if (!POMManager.dependenciesEqual((Dependency)it.next(), dependency)) continue;
            it.remove();
        }
        POMManager.writeModelToPOM(model, pom, logger);
    }

    private static boolean dependenciesEqual(Dependency d1, Dependency d2) {
        boolean result = true;
        if (d1 == null || d2 == null) {
            return d1 == d2;
        }
        result = result && d1.getGroupId().equals(d2.getGroupId());
        boolean bl = result = result && d1.getArtifactId().equals(d2.getArtifactId());
        if (d1.getVersion() != null) {
            result = result && d1.getVersion().equals(d2.getVersion());
        } else {
            boolean bl2 = result = result && d2.getVersion() == null;
        }
        if (d1.getType() != null) {
            result = result && d1.getType().equals(d2.getType());
        } else {
            boolean bl3 = result = result && d2.getType() == null;
        }
        result = d1.getClassifier() != null ? result && d1.getClassifier().equals(d2.getClassifier()) : result && d2.getClassifier() == null;
        return result;
    }

    private static boolean dependencyExists(Dependency dependency, List<Dependency> dependencies) {
        for (Dependency d : dependencies) {
            if (!POMManager.dependenciesEqual(dependency, d)) continue;
            return true;
        }
        return false;
    }

    public static boolean dependencyExists(File pom, Dependency dependency, Log logger) throws IOException, XmlPullParserException {
        Model model = POMManager.getModelFromPOM(pom, logger);
        return POMManager.dependencyExists(dependency, model.getDependencies());
    }

    public static boolean dependencyExistsManagement(File pom, Dependency dependency, Log logger) throws IOException, XmlPullParserException {
        Model model = POMManager.getModelFromPOM(pom, logger);
        DependencyManagement dMgmt = model.getDependencyManagement();
        if (dMgmt == null) {
            model.setDependencyManagement(new DependencyManagement());
            dMgmt = model.getDependencyManagement();
        }
        return POMManager.dependencyExists(dependency, dMgmt.getDependencies());
    }

    public static Profile getProfile(Model model, String profileId) {
        if (model == null || profileId == null || profileId.isEmpty()) {
            return null;
        }
        for (Profile profile : model.getProfiles()) {
            if (!profileId.equals(profile.getId())) continue;
            return profile;
        }
        Profile result = new Profile();
        result.setId(profileId);
        model.addProfile(result);
        return result;
    }

    public static void addProjectAsModule(File pom, String relativePath, String profileId, Log logger) throws IOException, XmlPullParserException {
        if (relativePath == null) {
            return;
        }
        Model model = POMManager.getModelFromPOM(pom, logger);
        relativePath = relativePath.replace("\\", "/");
        if (profileId != null && !profileId.isEmpty()) {
            Profile p = POMManager.getProfile(model, profileId);
            if (p != null) {
                p.addModule(relativePath);
            }
        } else {
            model.addModule(relativePath);
        }
        POMManager.writeModelToPOM(model, pom, logger);
    }

    public static void removeProjectAsModule(File pom, String relativePath, String profileId, Log logger) throws IOException, XmlPullParserException {
        if (relativePath == null) {
            return;
        }
        Model model = POMManager.getModelFromPOM(pom, logger);
        relativePath = relativePath.replace("\\", "/");
        if (profileId != null && !profileId.isEmpty()) {
            Profile p = POMManager.getProfile(model, profileId);
            if (p != null) {
                p.removeModule(relativePath);
            }
        } else {
            model.removeModule(relativePath);
        }
        POMManager.writeModelToPOM(model, pom, logger);
    }

    public static boolean moduleExists(File pom, String relativePath, String profileId, Log logger) throws IOException, XmlPullParserException {
        if (relativePath == null) {
            return false;
        }
        Model model = POMManager.getModelFromPOM(pom, logger);
        relativePath = relativePath.replace("\\", "/");
        if (profileId != null && !profileId.isEmpty()) {
            Profile p = POMManager.getProfile(model, profileId);
            if (p != null) {
                return p.getModules().indexOf(relativePath) >= 0;
            }
        } else {
            return model.getModules().indexOf(relativePath) >= 0;
        }
        return false;
    }
}

