/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.textstyling.html;

import fr.opensagres.xdocreport.document.textstyling.IDocumentHandler;
import fr.opensagres.xdocreport.document.textstyling.html.StylesHelper;
import fr.opensagres.xdocreport.document.textstyling.properties.HeaderProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ListItemProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ListProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.ParagraphProperties;
import fr.opensagres.xdocreport.document.textstyling.properties.SpanProperties;
import java.io.IOException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLTextStylingContentHandler
extends DefaultHandler {
    private static final String STYLE_ATTR = "style";
    private static final String STRONG_ELT = "strong";
    private static final String B_ELT = "b";
    private static final String EM_ELT = "em";
    private static final String I_ELT = "i";
    private static final String U_ELT = "u";
    private static final String STRIKE_ELT = "strike";
    private static final String S_ELT = "s";
    private static final String OL_ELT = "ol";
    private static final String UL_ELT = "ul";
    private static final String LI_ELT = "li";
    private static final String P_ELT = "p";
    private static final String H1_ELT = "h1";
    private static final String H2_ELT = "h2";
    private static final String H3_ELT = "h3";
    private static final String H4_ELT = "h4";
    private static final String H5_ELT = "h5";
    private static final String H6_ELT = "h6";
    private static final String A_ELT = "a";
    private static final String IMG_ELT = "img";
    private static final String HREF_ATTR = "href";
    private static final String SRC_ATTR = "src";
    private static final String BR_ELT = "br";
    private static final String SUB_ELT = "sub";
    private static final String SUP_ELT = "sup";
    private static final String SPAN_ELT = "span";
    private final IDocumentHandler documentHandler;
    private String aHref;
    private StringBuilder aContent;
    private boolean ignoreCharacters;

    public HTMLTextStylingContentHandler(IDocumentHandler visitor) {
        this.documentHandler = visitor;
        this.aHref = null;
        this.aContent = new StringBuilder();
        this.ignoreCharacters = false;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        try {
            this.documentHandler.startDocument();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        try {
            this.documentHandler.endDocument();
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.ignoreCharacters = false;
        try {
            if (STRONG_ELT.equals(name) || B_ELT.equals(name)) {
                this.documentHandler.startBold();
            } else if (EM_ELT.equals(name) || I_ELT.equals(name)) {
                this.documentHandler.startItalics();
            } else if (U_ELT.equals(name)) {
                this.documentHandler.startUnderline();
            } else if (STRIKE_ELT.equals(name) || S_ELT.equals(name)) {
                this.documentHandler.startStrike();
            } else if (SUB_ELT.equals(name)) {
                this.documentHandler.startSubscript();
            } else if (SUP_ELT.equals(name)) {
                this.documentHandler.startSuperscript();
            } else if (UL_ELT.equals(name)) {
                ListProperties properties = StylesHelper.createListProperties(attributes.getValue(STYLE_ATTR));
                this.startList(false, properties);
            } else if (OL_ELT.equals(name)) {
                ListProperties properties = StylesHelper.createListProperties(attributes.getValue(STYLE_ATTR));
                this.startList(true, properties);
            } else if (LI_ELT.equals(name)) {
                ListItemProperties properties = StylesHelper.createListItemProperties(attributes.getValue(STYLE_ATTR));
                this.documentHandler.startListItem(properties);
            } else if (P_ELT.equals(name)) {
                ParagraphProperties properties = StylesHelper.createParagraphProperties(attributes.getValue(STYLE_ATTR));
                this.documentHandler.startParagraph(properties);
            } else if (H1_ELT.equals(name)) {
                HeaderProperties properties = StylesHelper.createHeaderProperties(attributes.getValue(STYLE_ATTR));
                this.documentHandler.startHeading(1, properties);
            } else if (H2_ELT.equals(name)) {
                HeaderProperties properties = StylesHelper.createHeaderProperties(attributes.getValue(STYLE_ATTR));
                this.documentHandler.startHeading(2, properties);
            } else if (H3_ELT.equals(name)) {
                HeaderProperties properties = StylesHelper.createHeaderProperties(attributes.getValue(STYLE_ATTR));
                this.documentHandler.startHeading(3, properties);
            } else if (H4_ELT.equals(name)) {
                HeaderProperties properties = StylesHelper.createHeaderProperties(attributes.getValue(STYLE_ATTR));
                this.documentHandler.startHeading(4, properties);
            } else if (H5_ELT.equals(name)) {
                HeaderProperties properties = StylesHelper.createHeaderProperties(attributes.getValue(STYLE_ATTR));
                this.documentHandler.startHeading(5, properties);
            } else if (H6_ELT.equals(name)) {
                HeaderProperties properties = StylesHelper.createHeaderProperties(attributes.getValue(STYLE_ATTR));
                this.documentHandler.startHeading(6, properties);
            } else if (A_ELT.equals(name)) {
                this.aHref = attributes.getValue(HREF_ATTR);
            } else if (IMG_ELT.equals(name)) {
                String src = attributes.getValue(SRC_ATTR);
                this.documentHandler.handleImage(src, "");
            } else if (SPAN_ELT.equals(name)) {
                SpanProperties properties = StylesHelper.createSpanProperties(attributes.getValue(STYLE_ATTR));
                this.documentHandler.startSpan(properties);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        super.startElement(uri, localName, name, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.ignoreCharacters = false;
        try {
            if (STRONG_ELT.equals(name) || B_ELT.equals(name)) {
                this.documentHandler.endBold();
            } else if (EM_ELT.equals(name) || I_ELT.equals(name)) {
                this.documentHandler.endItalics();
            } else if (U_ELT.equals(name)) {
                this.documentHandler.endUnderline();
            } else if (STRIKE_ELT.equals(name) || S_ELT.equals(name)) {
                this.documentHandler.endStrike();
            } else if (SUB_ELT.equals(name)) {
                this.documentHandler.endSubscript();
            } else if (SUP_ELT.equals(name)) {
                this.documentHandler.endSuperscript();
            } else if (UL_ELT.equals(name)) {
                this.endList(false);
            } else if (OL_ELT.equals(name)) {
                this.endList(true);
            } else if (LI_ELT.equals(name)) {
                this.ignoreCharacters = true;
                this.documentHandler.endListItem();
            } else if (P_ELT.equals(name)) {
                this.documentHandler.endParagraph();
            } else if (H1_ELT.equals(name)) {
                this.documentHandler.endHeading(1);
            } else if (H2_ELT.equals(name)) {
                this.documentHandler.endHeading(2);
            } else if (H3_ELT.equals(name)) {
                this.documentHandler.endHeading(3);
            } else if (H4_ELT.equals(name)) {
                this.documentHandler.endHeading(4);
            } else if (H5_ELT.equals(name)) {
                this.documentHandler.endHeading(5);
            } else if (H6_ELT.equals(name)) {
                this.documentHandler.endHeading(6);
            } else if (A_ELT.equals(name)) {
                this.documentHandler.handleReference(this.aHref, this.aContent.toString());
                this.aHref = null;
                this.aContent.setLength(0);
            } else if (BR_ELT.equals(name)) {
                this.documentHandler.handleLineBreak();
            } else if (SPAN_ELT.equals(name)) {
                this.documentHandler.endSpan();
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        super.endElement(uri, localName, name);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.ignoreCharacters) {
            try {
                if (this.aHref != null) {
                    this.aContent.append(ch, start, length);
                } else {
                    this.documentHandler.handleString(String.valueOf(ch, start, length));
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }
        super.characters(ch, start, length);
    }

    private void startList(boolean ordered, ListProperties properties) throws IOException {
        this.ignoreCharacters = true;
        if (ordered) {
            this.documentHandler.startOrderedList(properties);
        } else {
            this.documentHandler.startUnorderedList(properties);
        }
    }

    private void endList(boolean ordered) throws IOException {
        if (ordered) {
            this.documentHandler.endOrderedList();
        } else {
            this.documentHandler.endUnorderedList();
        }
    }
}

