/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.registry;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.cache.CacheStorageRegistry;
import fr.opensagres.xdocreport.core.cache.ICacheStorage;
import fr.opensagres.xdocreport.core.io.IEntryInfo;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.registry.AbstractRegistry;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.discovery.IXDocReportFactoryDiscovery;
import fr.opensagres.xdocreport.document.registry.TemplateEngineInitializerRegistry;
import fr.opensagres.xdocreport.document.timing.AlarmTimer;
import fr.opensagres.xdocreport.document.timing.AlarmTimerListener;
import fr.opensagres.xdocreport.document.timing.PooledAlarmTimer;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.cache.ITemplateCacheInfoProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Logger;

public class XDocReportRegistry
extends AbstractRegistry<IXDocReportFactoryDiscovery>
implements ITemplateCacheInfoProvider,
Serializable {
    private static final long serialVersionUID = 1653550067972102340L;
    private static final Logger LOGGER = LogUtils.getLogger((String)AbstractRegistry.class.getName());
    private static final String FILES_TYPE_ERROR = "Impossible to create report for the input stream. The report loader supports only [{0}] files type.";
    private static final XDocReportRegistry INSTANCE = new XDocReportRegistry();
    private final Collection<IXDocReportFactoryDiscovery> reportFactoryDiscoveries = new ArrayList<IXDocReportFactoryDiscovery>();
    private final ICacheStorage<String, IXDocReport> cachedReports = this.createCache();

    public XDocReportRegistry() {
        super(IXDocReportFactoryDiscovery.class);
    }

    protected ICacheStorage<String, IXDocReport> createCache() {
        return CacheStorageRegistry.getRegistry().createCache();
    }

    public static XDocReportRegistry getRegistry() {
        return INSTANCE;
    }

    public IXDocReport loadReport(InputStream sourceStream) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, null, null, null, true);
    }

    public IXDocReport loadReport(InputStream sourceStream, boolean cacheReport) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, null, null, null, cacheReport);
    }

    public IXDocReport loadReport(InputStream sourceStream, String reportId) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, reportId, true);
    }

    public IXDocReport loadReport(InputStream sourceStream, String reportId, boolean cacheReport) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, reportId, null, null, cacheReport);
    }

    public IXDocReport loadReport(InputStream sourceStream, String reportId, ITemplateEngine templateEngine) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, reportId, null, templateEngine, true);
    }

    public IXDocReport loadReport(InputStream sourceStream, String reportId, ITemplateEngine templateEngine, boolean cacheReport) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, reportId, null, templateEngine, cacheReport);
    }

    public IXDocReport loadReport(InputStream sourceStream, String reportId, String templateEngineKind) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, reportId, templateEngineKind, true);
    }

    public IXDocReport loadReport(InputStream sourceStream, String reportId, String templateEngineKind, boolean cacheReport) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, reportId, templateEngineKind, null, cacheReport);
    }

    public IXDocReport loadReport(InputStream sourceStream, String reportId, TemplateEngineKind templateEngineKind) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, reportId, templateEngineKind, true);
    }

    public IXDocReport loadReport(InputStream sourceStream, String reportId, TemplateEngineKind templateEngineKind, boolean cacheReport) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, reportId, templateEngineKind.name(), null, cacheReport);
    }

    public IXDocReport loadReport(InputStream sourceStream, ITemplateEngine templateEngine) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, templateEngine, true);
    }

    public IXDocReport loadReport(InputStream sourceStream, ITemplateEngine templateEngine, boolean cacheReport) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, null, null, templateEngine, cacheReport);
    }

    public IXDocReport loadReport(InputStream sourceStream, TemplateEngineKind templateEngineKind) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, templateEngineKind, true);
    }

    public IXDocReport loadReport(InputStream sourceStream, TemplateEngineKind templateEngineKind, boolean cacheReport) throws IOException, XDocReportException {
        return this.loadReport(sourceStream, null, templateEngineKind.name(), null, cacheReport);
    }

    private IXDocReport loadReport(InputStream sourceStream, String reportId, String templateEngineKind, ITemplateEngine templateEngine, boolean cacheReport) throws IOException, XDocReportException {
        this.initializeIfNeeded();
        IXDocReport report = this.createReport(sourceStream);
        if (StringUtils.isEmpty((String)reportId)) {
            reportId = report.toString();
        }
        report.setId(reportId);
        if (templateEngine == null && StringUtils.isNotEmpty((String)templateEngineKind)) {
            String documentKind = report.getKind();
            templateEngine = TemplateEngineInitializerRegistry.getRegistry().getTemplateEngine(templateEngineKind, documentKind);
            if (templateEngine == null) {
                templateEngine = TemplateEngineInitializerRegistry.getRegistry().getTemplateEngine(templateEngineKind, null);
            }
        }
        report.setTemplateEngine(templateEngine);
        if (cacheReport) {
            this.registerReport(report);
        }
        return report;
    }

    public IXDocReport createReport(InputStream sourceStream) throws IOException, XDocReportException {
        XDocArchive documentArchive = XDocArchive.readZip((InputStream)sourceStream);
        return this.createReport(documentArchive);
    }

    public IXDocReport createReport(XDocArchive documentArchive) throws IOException, XDocReportException {
        this.initializeIfNeeded();
        for (IXDocReportFactoryDiscovery discovery : this.reportFactoryDiscoveries) {
            if (!discovery.isAdaptFor(documentArchive)) continue;
            IXDocReport report = discovery.createReport();
            if (report != null) {
                report.setDocumentArchive(documentArchive);
            }
            return report;
        }
        throw new XDocReportException(MessageFormat.format(FILES_TYPE_ERROR, this.getFilesType()));
    }

    private String getFilesType() {
        StringBuilder filesType = new StringBuilder();
        Collection<IXDocReportFactoryDiscovery> discoveries = this.getReportFactoryDiscoveries();
        for (IXDocReportFactoryDiscovery discovery : discoveries) {
            if (filesType.length() > 0) {
                filesType.append(",");
            }
            filesType.append(discovery.getMimeMapping().getExtension());
        }
        return filesType.toString();
    }

    public void registerReport(IXDocReport report) throws XDocReportException {
        this.registerReport(report, false);
    }

    public synchronized void registerReport(IXDocReport report, boolean force) throws XDocReportException {
        String reportId = report.getId();
        if (StringUtils.isEmpty((String)reportId)) {
            throw new XDocReportException("Cannot register report. IXDocReport#getId() cannot be empty.");
        }
        if (!force) {
            this.checkReportId(reportId);
        }
        this.cachedReports.put((Object)report.getId(), (Object)report);
    }

    public void checkReportId(String reportId) throws XDocReportException {
        if (this.cachedReports.containsKey((Object)reportId)) {
            String msg = String.format("Cannot register report. A report with id=%s already exists in the registry", reportId);
            LOGGER.warning(msg);
            throw new XDocReportException(msg);
        }
    }

    public IXDocReport getReport(String reportId) {
        return (IXDocReport)this.cachedReports.get((Object)reportId);
    }

    public boolean existsReport(String reportId) {
        return this.cachedReports.containsKey((Object)reportId);
    }

    public void unregisterReport(String reportId) {
        if (this.existsReport(reportId)) {
            this.cachedReports.remove((Object)reportId);
        }
    }

    public void unregisterReport(IXDocReport report) {
        if (report != null) {
            this.cachedReports.remove((Object)report.getId());
        }
    }

    public Collection<IXDocReportFactoryDiscovery> getReportFactoryDiscoveries() {
        this.initializeIfNeeded();
        return this.reportFactoryDiscoveries;
    }

    public Collection<IXDocReport> getCachedReports() {
        return Collections.unmodifiableCollection(this.cachedReports.values());
    }

    public void setClearTimeout(long timeout) {
        PooledAlarmTimer pooledAlarmTimer = new PooledAlarmTimer(timeout);
        pooledAlarmTimer.addAlarmTimerListener(new AlarmTimerListener(){

            @Override
            public void alarm(AlarmTimer timer) {
                XDocReportRegistry.this.clear();
            }
        });
    }

    public void clear() {
        this.cachedReports.clear();
    }

    public MimeMapping getMimeMapping(String fileExtension) throws IOException, XDocReportException {
        this.initializeIfNeeded();
        for (IXDocReportFactoryDiscovery discovery : this.reportFactoryDiscoveries) {
            if (!discovery.isAdaptFor(fileExtension)) continue;
            return discovery.getMimeMapping();
        }
        return null;
    }

    public synchronized String generateUniqueReportId(String reportId) {
        IXDocReport report = this.getReport(reportId);
        if (report != null) {
            StringBuilder id = new StringBuilder(reportId);
            id.append("_");
            id.append(System.currentTimeMillis());
            return id.toString();
        }
        return reportId;
    }

    public IEntryInfo getTemplateCacheInfo(String reportId, String entryName) {
        IXDocReport report = this.getReport(reportId);
        if (report == null) {
            return null;
        }
        return report.getPreprocessedDocumentArchive().getEntryInfo(entryName);
    }

    protected void doDispose() {
        this.reportFactoryDiscoveries.clear();
        this.cachedReports.clear();
    }

    protected boolean registerInstance(IXDocReportFactoryDiscovery instance) {
        this.reportFactoryDiscoveries.add(instance);
        return true;
    }
}

