/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.preprocessor.sax;

import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocument;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.RowBufferedRegion;
import fr.opensagres.xdocreport.document.preprocessor.sax.TableBufferedRegion;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class TransformedBufferedDocument
extends BufferedDocument {
    private final Stack<TableBufferedRegion> tableStack = new Stack();
    protected RowBufferedRegion currentRow;

    protected BufferedElement createElement(BufferedElement parent, String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.isTable(uri, localName, name)) {
            TableBufferedRegion currentTable = new TableBufferedRegion(this.getCurrentElement(), uri, localName, name, attributes);
            this.tableStack.push(currentTable);
            return currentTable;
        }
        if (this.isTableRow(uri, localName, name)) {
            if (this.tableStack.size() < 1) {
                throw new SAXException("XML mal formatted. XML Row must be included in a XML Table");
            }
            this.currentRow = new RowBufferedRegion(this.getCurrentElement(), uri, localName, name, attributes);
            return this.currentRow;
        }
        return super.createElement(parent, uri, localName, name, attributes);
    }

    public void onEndEndElement(String uri, String localName, String name) {
        if (this.isTable(uri, localName, name)) {
            this.tableStack.pop();
        } else if (this.isTableRow(uri, localName, name)) {
            this.currentRow = null;
        }
        super.onEndEndElement(uri, localName, name);
    }

    protected abstract boolean isTable(String var1, String var2, String var3);

    protected abstract boolean isTableRow(String var1, String var2, String var3);

    public TableBufferedRegion getCurrentTable() {
        if (!this.tableStack.isEmpty()) {
            return this.tableStack.peek();
        }
        return null;
    }

    public RowBufferedRegion getCurrentTableRow() {
        return this.currentRow;
    }
}

