/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.web;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.registry.XDocReportRegistry;
import fr.opensagres.xdocreport.document.web.BaseXDocReportServlet;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class UploadXDocReportServlet
extends BaseXDocReportServlet {
    private static final long serialVersionUID = 9102651291455406387L;
    private static final String LOADREPORT_JSP = "loadReport.jsp";

    @Override
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doUpload(request, response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doUpload(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
        if (!isMultipart) return;
        DiskFileItemFactory factory = new DiskFileItemFactory();
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        try {
            List items = upload.parseRequest(request);
            for (FileItem fileItem : items) {
                if (!"uploadfile".equals(fileItem.getFieldName())) continue;
                InputStream in = fileItem.getInputStream();
                try {
                    String reportId = this.generateReportId(fileItem, request);
                    IXDocReport report = this.getRegistryForUpload(request).loadReport(in, reportId);
                    this.getRegistry(request).checkReportId(report.getId());
                    this.reportLoaded(report, request);
                    this.doForward(report, request, response);
                    return;
                }
                catch (XDocReportException e) {
                    throw new ServletException((Throwable)e);
                    return;
                }
            }
        }
        catch (FileUploadException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void reportLoaded(IXDocReport report, HttpServletRequest request) {
    }

    protected String generateReportId(FileItem fileItem, HttpServletRequest request) {
        String reportId = fileItem.getName();
        int index = reportId.lastIndexOf(47);
        if (index == -1) {
            index = reportId.lastIndexOf(92);
        }
        if (index != -1) {
            reportId = reportId.substring(index + 1, reportId.length());
        }
        return this.getRegistry(request).generateUniqueReportId(reportId);
    }

    protected void doForward(IXDocReport report, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (report != null) {
            request.setAttribute("XDocReport", (Object)report);
        }
        request.getRequestDispatcher(LOADREPORT_JSP).forward((ServletRequest)request, (ServletResponse)response);
    }

    protected XDocReportRegistry getRegistryForUpload(HttpServletRequest request) {
        return super.getRegistry(request);
    }
}

