/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt.preprocessor;

import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.odt.ODTUtils;
import fr.opensagres.xdocreport.document.odt.preprocessor.ODTAnnotationParsingHelper;
import fr.opensagres.xdocreport.document.odt.preprocessor.ODTBufferedDocument;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.preprocessor.sax.TransformedBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ODTBufferedDocumentContentHandler
extends TransformedBufferedDocumentContentHandler<ODTBufferedDocument> {
    private static final String TEXT_P = "text:p";
    private String dynamicImageName;
    private boolean textInputParsing = false;
    private ODTAnnotationParsingHelper annotationHelper = new ODTAnnotationParsingHelper();

    public ODTBufferedDocumentContentHandler(String entryName, FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext) {
        super(entryName, fieldsMetadata, formatter, sharedContext);
    }

    protected ODTBufferedDocument createDocument() {
        return new ODTBufferedDocument();
    }

    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        FieldsMetadata fieldsMetadata = super.getFieldsMetadata();
        IDocumentFormatter formatter = super.getFormatter();
        if (this.annotationHelper.isParsing()) {
            this.annotationHelper.setCurrentElement(uri, localName, name);
            return false;
        }
        if (ODTUtils.isAnnotationEnd(uri, localName, name)) {
            String annotationName = attributes.getValue("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "name");
            this.annotationHelper.resetRangeAnnotation(annotationName, false);
            return false;
        }
        if (ODTUtils.isTextInput(uri, localName, name)) {
            this.textInputParsing = true;
            return false;
        }
        if (ODTUtils.isTextA(uri, localName, name)) {
            String newHref;
            String href;
            if (fieldsMetadata != null && formatter != null && StringUtils.isNotEmpty((String)(href = attributes.getValue("http://www.w3.org/1999/xlink", "href"))) && (newHref = this.processRowIfNeeded(StringUtils.decode((String)href))) != null) {
                if (StringUtils.isNotEmpty((String)this.getStartNoParse())) {
                    this.getCurrentElement().setContentBeforeStartTagElement(this.getEndNoParse());
                    this.getCurrentElement().setContentAfterEndTagElement(this.getStartNoParse());
                }
                AttributesImpl attributesImpl = ODTBufferedDocumentContentHandler.toAttributesImpl((Attributes)attributes);
                int index = attributesImpl.getIndex("http://www.w3.org/1999/xlink", "href");
                attributesImpl.setValue(index, newHref);
                attributes = attributesImpl;
            }
        } else if (ODTUtils.isDrawFrame(uri, localName, name)) {
            String drawName;
            String imageFieldName;
            if (fieldsMetadata != null && (imageFieldName = fieldsMetadata.getImageFieldName(drawName = attributes.getValue("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name"))) != null) {
                this.dynamicImageName = this.processRowIfNeeded(imageFieldName, true);
                if (this.dynamicImageName != null && formatter != null) {
                    int heightIndex;
                    String set = formatter.getSetDirective("___imageInfo", formatter.getFunctionDirective(false, "___ImageRegistry", "registerImage", new String[]{this.dynamicImageName, "'" + drawName + "'", "___context"}), false);
                    String imageInfoIf = formatter.getStartIfDirective(formatter.formatAsSimpleField(false, new String[]{"___imageInfo", "notRemoveImageTemplate"}), false);
                    StringBuilder before = new StringBuilder();
                    before.append(set);
                    before.append(imageInfoIf);
                    String after = formatter.getEndIfDirective("___imageInfo");
                    if (StringUtils.isNotEmpty((String)this.getStartNoParse())) {
                        this.getCurrentElement().setContentBeforeStartTagElement(this.getEndNoParse() + before.toString());
                        this.getCurrentElement().setContentAfterEndTagElement(this.getStartNoParse() + after.toString());
                    } else {
                        this.getCurrentElement().setContentBeforeStartTagElement(before.toString());
                        this.getCurrentElement().setContentAfterEndTagElement(after.toString());
                    }
                    String newWith = null;
                    String newHeight = null;
                    int widthIndex = attributes.getIndex("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "width");
                    if (widthIndex != -1) {
                        String defaultWidth = attributes.getValue(widthIndex);
                        newWith = formatter.getFunctionDirective("___ImageRegistry", "getWidth", new String[]{"___imageInfo", "'" + defaultWidth + "'"});
                    }
                    if ((heightIndex = attributes.getIndex("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0", "height")) != -1) {
                        String defaultHeight = attributes.getValue(heightIndex);
                        newHeight = formatter.getFunctionDirective("___ImageRegistry", "getHeight", new String[]{"___imageInfo", "'" + defaultHeight + "'"});
                    }
                    if (newWith != null || newHeight != null) {
                        AttributesImpl attr = ODTBufferedDocumentContentHandler.toAttributesImpl((Attributes)attributes);
                        if (newWith != null) {
                            attr.setValue(widthIndex, newWith);
                        }
                        if (newHeight != null) {
                            attr.setValue(heightIndex, newHeight);
                        }
                        attributes = attr;
                    }
                }
            }
        } else if (ODTUtils.isDrawImage(uri, localName, name)) {
            int index;
            if (this.dynamicImageName != null && formatter != null && (index = attributes.getIndex("http://www.w3.org/1999/xlink", "href")) != -1) {
                String href = attributes.getValue(index);
                String newHref = formatter.getFunctionDirective("___ImageRegistry", "getPath", new String[]{"___imageInfo", "'" + href + "'"});
                AttributesImpl attributesImpl = ODTBufferedDocumentContentHandler.toAttributesImpl((Attributes)attributes);
                attributesImpl.setValue(index, newHref);
                attributes = attributesImpl;
            }
        } else if (ODTUtils.isAnnotation(uri, localName, name)) {
            if (!this.annotationHelper.isRangeAnnotation()) {
                String annotationName = attributes.getValue("urn:oasis:names:tc:opendocument:xmlns:office:1.0", "name");
                this.annotationHelper.setParsingBegin(annotationName, this.getElementIndex());
            }
            return false;
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    public void doEndElement(String uri, String localName, String name) throws SAXException {
        if (ODTUtils.isAnnotation(uri, localName, name)) {
            if (this.annotationHelper.isParsing()) {
                this.annotationHelper.setParsingEnd();
                if (!this.annotationHelper.isRangeAnnotation()) {
                    BufferedElement elementInfo = this.findParentElementInfo(this.annotationHelper.getParents());
                    if (elementInfo != null) {
                        if (this.annotationHelper.hasBefore()) {
                            String before = this.formatDirective(this.annotationHelper.getBefore());
                            elementInfo.setContentBeforeStartTagElement(before);
                        }
                        if (this.annotationHelper.hasAfter()) {
                            String after = this.formatDirective(this.annotationHelper.getAfter());
                            elementInfo.setContentAfterEndTagElement(after);
                        }
                    }
                    if (this.annotationHelper.hasReplacement()) {
                        String replacement = this.formatDirective(this.annotationHelper.getReplacement());
                        this.getCurrentElement().setInnerText(replacement);
                    }
                }
            }
            return;
        }
        if (this.annotationHelper.isParsing() || ODTUtils.isAnnotationEnd(uri, localName, name)) {
            return;
        }
        if (ODTUtils.isTextInput(uri, localName, name)) {
            this.textInputParsing = false;
        } else {
            if (ODTUtils.isDrawFrame(uri, localName, name)) {
                this.dynamicImageName = null;
            } else if (!ODTUtils.isOfficeAutomaticStyles(uri, localName, name) || this.needToProcessAutomaticStyles()) {
                // empty if block
            }
            super.doEndElement(uri, localName, name);
        }
    }

    protected boolean needToProcessAutomaticStyles() {
        return true;
    }

    protected String getTableTableName() {
        return "table:table";
    }

    protected String getTableRowName() {
        return "table:table-row";
    }

    protected String getTableCellName() {
        return "table:table-cell";
    }

    protected void flushCharacters(String characters) {
        if (this.textInputParsing || this.annotationHelper.isParsing() || this.annotationHelper.isRangeAnnotation()) {
            IDocumentFormatter formatter = this.getFormatter();
            if (formatter != null && (formatter.containsInterpolation(characters) || formatter.hasDirective(characters))) {
                characters = StringUtils.xmlUnescape((String)characters);
            }
            characters = this.customFormat(characters, formatter);
            if (this.textInputParsing) {
                String fieldName = characters;
                if (this.processScriptBefore(fieldName)) {
                    return;
                }
                if (this.processScriptAfter(fieldName)) {
                    return;
                }
                if (this.getFormatter() != null) {
                    FieldMetadata fieldAsTextStyling = this.getFieldAsTextStyling(fieldName);
                    if (fieldAsTextStyling != null) {
                        long variableIndex = this.getVariableIndex();
                        BufferedElement textPElement = this.getCurrentElement().findParent(TEXT_P);
                        if (textPElement == null) {
                            textPElement = this.getCurrentElement().getParent();
                        }
                        String elementId = this.registerBufferedElement(variableIndex, textPElement);
                        String newFieldName = super.processRowIfNeeded(fieldName);
                        if (StringUtils.isEmpty((String)newFieldName)) {
                            newFieldName = fieldName;
                        }
                        String setVariableDirective = this.getFormatter().formatAsCallTextStyling(variableIndex, newFieldName, DocumentKind.ODT.name(), fieldAsTextStyling.getSyntaxKind(), fieldAsTextStyling.isSyntaxWithDirective(), elementId, super.getEntryName());
                        String textBefore = this.getFormatter().formatAsTextStylingField(variableIndex, "textBefore");
                        String textBody = this.getFormatter().formatAsTextStylingField(variableIndex, "textBody");
                        String textEnd = this.getFormatter().formatAsTextStylingField(variableIndex, "textEnd");
                        textPElement.setContentBeforeStartTagElement(this.formatDirective(setVariableDirective + textBefore));
                        textPElement.setContentAfterEndTagElement(this.formatDirective(textEnd));
                        super.flushCharacters(this.formatDirective(textBody));
                        return;
                    }
                    characters = this.formatDirective(characters);
                }
                super.flushCharacters(characters);
            } else if (this.annotationHelper.isParsing()) {
                this.annotationHelper.append(characters);
            } else if (StringUtils.isNotEmpty((String)characters) && this.annotationHelper.isNotReplacedYet()) {
                this.annotationHelper.setReplacementDone();
                BufferedElement container = this.getCurrentElement();
                if (this.annotationHelper.hasBefore()) {
                    String before = this.formatDirective(this.annotationHelper.getBefore());
                    container.setContentBeforeStartTagElement(before);
                }
                if (this.annotationHelper.hasAfter()) {
                    String after = this.formatDirective(this.annotationHelper.getAfter());
                    container.setContentAfterEndTagElement(after);
                }
                if (this.annotationHelper.hasReplacement()) {
                    String replacement = this.formatDirective(this.annotationHelper.getReplacement());
                    this.getCurrentElement().setInnerText(replacement);
                }
            }
        } else {
            super.flushCharacters(characters);
        }
    }

    private String customFormat(String content, IDocumentFormatter formatter) {
        FieldsMetadata metadata = this.getFieldsMetadata();
        if (metadata == null) {
            return content;
        }
        String newContent = metadata.customFormat(content, formatter);
        return newContent != null ? newContent : content;
    }
}

