/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.formatter;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.template.annotations.FieldMetada;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IFieldsMetadataClassSerializer;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFieldsMetadataClassSerializer
implements IFieldsMetadataClassSerializer {
    private final String id;
    private final String description;
    private final List<String> excludedPackages;

    public AbstractFieldsMetadataClassSerializer(String id, String description) {
        this.id = id;
        this.description = description;
        this.excludedPackages = new ArrayList<String>();
        this.excludedPackages.add("java.");
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public void load(FieldsMetadata fieldsMetadata, String key, Class<?> clazz) throws XDocReportException {
        this.load(fieldsMetadata, key, clazz, false);
    }

    @Override
    public void load(FieldsMetadata fieldsMetadata, String key, Class<?> clazz, boolean listType) throws XDocReportException {
        try {
            ArrayList<PropertyDescriptor> path = new ArrayList<PropertyDescriptor>();
            this.process(fieldsMetadata, key, clazz, path, listType);
        }
        catch (Exception e) {
            throw new XDocReportException((Throwable)e);
        }
    }

    private void process(FieldsMetadata fieldsMetadata, String key, Class<?> clazz, List<PropertyDescriptor> path, boolean isList) throws IntrospectionException {
        PropertyDescriptor[] descs;
        BeanInfo infos = Introspector.getBeanInfo(clazz);
        for (PropertyDescriptor propertyDescriptor : descs = infos.getPropertyDescriptors()) {
            if (this.isTransient(propertyDescriptor, clazz) || !this.haveGetterMethod(propertyDescriptor)) continue;
            Method method = propertyDescriptor.getReadMethod();
            Class<?> returnTypeClass = method.getReturnType();
            boolean wasVisited = false;
            for (PropertyDescriptor item : path) {
                if (!item.equals(propertyDescriptor)) continue;
                wasVisited = true;
                break;
            }
            if (wasVisited) continue;
            if (Iterable.class.isAssignableFrom(returnTypeClass)) {
                ParameterizedType parameterizedType;
                Type[] types;
                Type collectionType = method.getGenericReturnType();
                if (collectionType == null || !(collectionType instanceof ParameterizedType) || (types = (parameterizedType = (ParameterizedType)method.getGenericReturnType()).getActualTypeArguments()).length != 1) continue;
                Class itemClazz = (Class)types[0];
                if (String.class.isAssignableFrom(itemClazz) || this.isClassToExclude(itemClazz)) {
                    this.addField(key, fieldsMetadata, path, propertyDescriptor, true);
                    continue;
                }
                path.add(propertyDescriptor);
                this.process(fieldsMetadata, key, itemClazz, path, true);
                path.remove(propertyDescriptor);
                continue;
            }
            if (String.class.isAssignableFrom(returnTypeClass) || this.isClassToExclude(returnTypeClass)) {
                this.addField(key, fieldsMetadata, path, propertyDescriptor, isList);
                continue;
            }
            path.add(propertyDescriptor);
            this.process(fieldsMetadata, key, returnTypeClass, path, isList);
            path.remove(propertyDescriptor);
        }
    }

    private void addField(String key, FieldsMetadata fieldsMetadata, List<PropertyDescriptor> path, PropertyDescriptor currentField, Boolean isList) {
        StringBuffer fieldName = new StringBuffer(key);
        for (PropertyDescriptor fieldFromPath : path) {
            fieldName.append(this.getFieldName("", fieldFromPath.getName()));
        }
        fieldName.append(this.getFieldName("", currentField.getName()));
        for (FieldMetadata fieldMetadata : fieldsMetadata.getFields()) {
            if (!fieldMetadata.getFieldName().equals(fieldName.toString())) continue;
            return;
        }
        Method method = currentField.getReadMethod();
        FieldMetada fMetadata = method.getAnnotation(FieldMetada.class);
        if (fMetadata != null) {
            FieldMetadata newField = fieldsMetadata.addField(fieldName.toString(), isList, null, fMetadata.syntaxKind(), fMetadata.syntaxWithDirective());
            newField.setDescription(fMetadata.description());
        } else {
            fieldsMetadata.addField(fieldName.toString(), isList, null, null, null);
        }
    }

    private boolean isTransient(PropertyDescriptor propertyDescriptor, Class<?> clazz) {
        try {
            if (clazz != null) {
                Field field = clazz.getDeclaredField(propertyDescriptor.getName());
                return Modifier.isTransient(field.getModifiers());
            }
            return false;
        }
        catch (SecurityException e) {
            return true;
        }
        catch (NoSuchFieldException e) {
            Class<?>[] interfaces;
            if (this.isTransient(propertyDescriptor, clazz.getSuperclass())) {
                return true;
            }
            for (Class<?> _interfase : interfaces = clazz.getInterfaces()) {
                if (!this.isTransient(propertyDescriptor, _interfase)) continue;
                return true;
            }
            return false;
        }
    }

    private boolean haveGetterMethod(PropertyDescriptor propertyDescriptor) {
        Method method = propertyDescriptor.getReadMethod();
        return this.isGetterMethod(method);
    }

    private boolean isClassToExclude(Class<?> clazz) {
        if (clazz != null && clazz.getPackage() != null) {
            String packageName = clazz.getPackage().getName();
            for (String excludePackageName : this.excludedPackages) {
                if (!packageName.startsWith(excludePackageName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isGetterMethod(Method method) {
        if (method == null) {
            return false;
        }
        String name = method.getName();
        return !name.equals("getClass") && (name.startsWith("get") || name.startsWith("is"));
    }

    protected abstract String getFieldName(String var1, String var2);
}

