/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.styles.run;

import java.util.List;
import org.apache.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import org.apache.poi.xwpf.converter.core.styles.run.AbstractRunValueProvider;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontCollection;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontScheme;
import org.openxmlformats.schemas.drawingml.x2006.main.ThemeDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFonts;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTheme;

public class RunFontFamilyValueProvider
extends AbstractRunValueProvider<String> {
    public static RunFontFamilyValueProvider INSTANCE = new RunFontFamilyValueProvider();

    @Override
    public String getValue(CTRPr ppr) {
        CTFonts fonts = this.getRFonts(ppr);
        if (fonts != null) {
            return fonts.getAscii();
        }
        return null;
    }

    private CTFonts getRFonts(CTRPr ppr) {
        if (ppr == null) {
            return null;
        }
        return ppr.getRFonts();
    }

    @Override
    protected String getValueFromDocDefaultsStyle(CTDocDefaults docDefaults, XWPFStylesDocument stylesDocument) {
        CTFonts fonts = this.getRFonts(this.getRPr(docDefaults));
        if (fonts != null) {
            return this.getFontFamily(stylesDocument, fonts);
        }
        return "Times New Roman";
    }

    private String getFontFamily(XWPFStylesDocument stylesDocument, CTFonts fonts) {
        STTheme.Enum asciiTheme = fonts.getAsciiTheme();
        if (asciiTheme != null) {
            try {
                List<ThemeDocument> themeDocuments = stylesDocument.getThemeDocuments();
                if (themeDocuments.size() > 0) {
                    for (ThemeDocument themeDocument : themeDocuments) {
                        CTFontCollection fontCollection = this.getFontCollection(themeDocument, asciiTheme);
                        if (fontCollection == null || fontCollection.getLatin() == null) continue;
                        return fontCollection.getLatin().getTypeface();
                    }
                }
                return this.getDefaultFontFamily(asciiTheme);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return fonts.getAscii();
    }

    private String getDefaultFontFamily(STTheme.Enum asciiTheme) {
        if (asciiTheme.equals(STTheme.MINOR_H_ANSI)) {
            return "Calibri";
        }
        return null;
    }

    private CTFontCollection getFontCollection(ThemeDocument themeDocument, STTheme.Enum asciiTheme) {
        CTFontScheme fontScheme = themeDocument.getTheme().getThemeElements().getFontScheme();
        if (fontScheme != null) {
            if (asciiTheme.equals(STTheme.MINOR_ASCII) || asciiTheme.equals(STTheme.MINOR_BIDI) || asciiTheme.equals(STTheme.MINOR_EAST_ASIA) || asciiTheme.equals(STTheme.MINOR_H_ANSI)) {
                return fontScheme.getMinorFont();
            }
            return fontScheme.getMajorFont();
        }
        return null;
    }
}

