/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.styles.table;

import java.math.BigInteger;
import org.apache.poi.xwpf.converter.core.styles.table.AbstractTableValueProvider;
import org.apache.poi.xwpf.converter.core.utils.DxaUtil;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTblWidth;

public class TableIndentationValueProvider
extends AbstractTableValueProvider<Float> {
    public static final TableIndentationValueProvider INSTANCE = new TableIndentationValueProvider();

    @Override
    public Float getValue(CTTblPr tblPr) {
        return this.getTableAlignment((CTTblPrBase)tblPr);
    }

    @Override
    public Float getValue(CTTblPrBase tblPr) {
        return this.getTableAlignment(tblPr);
    }

    private Float getTableAlignment(CTTblPrBase tblPr) {
        if (tblPr == null) {
            return null;
        }
        CTTblWidth tblWidth = tblPr.getTblInd();
        if (tblWidth != null) {
            BigInteger width;
            STTblWidth.Enum type = tblWidth.getType();
            if (type != null) {
                // empty if block
            }
            if ((width = tblWidth.getW()) != null) {
                return Float.valueOf(DxaUtil.dxa2points(width));
            }
        }
        return null;
    }
}

