/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.poi.xwpf.converter.core.IXWPFMasterPage;
import org.apache.poi.xwpf.converter.core.XWPFDocumentVisitor;
import org.apache.poi.xwpf.converter.core.utils.XWPFUtils;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHdrFtrRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STHdrFtr;

public class MasterPageManager
extends LinkedList<CTSectPr> {
    private final XWPFDocument document;
    private final XWPFDocumentVisitor documentHandler;
    private final CTSectPr bodySectPr;
    private CTSectPr currentSectPr;
    private final Map<CTSectPr, IXWPFMasterPage> masterPages;
    private boolean initialized;
    private boolean changeSection;
    private int nbPages;
    private IXWPFMasterPage currentMasterPage;

    public MasterPageManager(XWPFDocument document, XWPFDocumentVisitor visitor) throws Exception {
        this.document = document;
        this.documentHandler = visitor;
        this.bodySectPr = document.getDocument().getBody().getSectPr();
        this.masterPages = new HashMap<CTSectPr, IXWPFMasterPage>();
        this.initialized = false;
        this.changeSection = false;
        this.nbPages = 0;
    }

    public void initialize() throws Exception {
        this.initialized = true;
        this.compute(this.document);
        if (this.isEmpty()) {
            this.currentSectPr = this.bodySectPr;
            this.addSection(this.currentSectPr, false);
            this.fireSectionChanged(this.currentSectPr);
        } else {
            this.currentSectPr = (CTSectPr)super.poll();
            this.fireSectionChanged(this.currentSectPr);
        }
    }

    private void compute(XWPFDocument document) throws Exception {
        for (IBodyElement bodyElement : document.getBodyElements()) {
            XWPFParagraph paragraph;
            CTSectPr sectPr;
            if (bodyElement.getElementType() != BodyElementType.PARAGRAPH || (sectPr = this.getSectPr(paragraph = (XWPFParagraph)bodyElement)) == null) continue;
            this.addSection(sectPr, true);
        }
        this.addSection(this.bodySectPr, false);
    }

    public CTSectPr getBodySectPr() {
        return this.bodySectPr;
    }

    public void update(XWPFParagraph paragraph) {
        if (this.changeSection) {
            this.changeSection = false;
            if (!this.isEmpty()) {
                this.currentSectPr = (CTSectPr)super.poll();
                this.fireSectionChanged(this.currentSectPr);
            } else {
                this.currentSectPr = this.bodySectPr;
                this.fireSectionChanged(this.currentSectPr);
            }
        } else {
            CTSectPr sectPr = this.getSectPr(paragraph);
            if (sectPr != null) {
                this.currentSectPr = sectPr;
                this.changeSection = true;
            }
        }
    }

    private void fireSectionChanged(CTSectPr sectPr) {
        this.currentMasterPage = this.getMasterPage(sectPr);
        this.documentHandler.setActiveMasterPage(this.currentMasterPage);
    }

    private void addSection(CTSectPr sectPr, boolean pushIt) throws Exception {
        if (pushIt) {
            super.add(sectPr);
        }
        IXWPFMasterPage masterPage = this.documentHandler.createMasterPage(sectPr);
        this.visitHeadersFooters(masterPage, sectPr);
        this.masterPages.put(sectPr, masterPage);
    }

    private void visitHeadersFooters(IXWPFMasterPage masterPage, CTSectPr sectPr) throws Exception {
        STHdrFtr type;
        boolean ignoreFirstHeaderFooter = !XWPFUtils.isCTOnOff(sectPr.getTitlePg());
        List headersRef = sectPr.getHeaderReferenceList();
        List footersRef = sectPr.getFooterReferenceList();
        boolean firstHeaderFooter = false;
        for (CTHdrFtrRef headerRef : headersRef) {
            type = headerRef.xgetType();
            boolean bl = firstHeaderFooter = type != null && type.enumValue() == STHdrFtr.FIRST;
            if (firstHeaderFooter && (!firstHeaderFooter || ignoreFirstHeaderFooter)) continue;
            masterPage.setType(type.enumValue().intValue());
            this.documentHandler.visitHeaderRef(headerRef, sectPr, masterPage);
        }
        for (CTHdrFtrRef footerRef : footersRef) {
            type = footerRef.xgetType();
            boolean bl = firstHeaderFooter = type != null && type.enumValue() == STHdrFtr.FIRST;
            if (firstHeaderFooter && (!firstHeaderFooter || ignoreFirstHeaderFooter)) continue;
            masterPage.setType(type.enumValue().intValue());
            this.documentHandler.visitFooterRef(footerRef, sectPr, masterPage);
        }
        masterPage.setType(3);
    }

    private CTSectPr getSectPr(XWPFParagraph paragraph) {
        CTPPr ppr = paragraph.getCTP().getPPr();
        if (ppr != null) {
            return ppr.getSectPr();
        }
        return null;
    }

    public IXWPFMasterPage getMasterPage(CTSectPr sectPr) {
        return this.masterPages.get(sectPr);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void onNewPage() {
        if (this.currentMasterPage != null) {
            int oldType = this.currentMasterPage.getType();
            int newType = 2;
            if (this.nbPages % 2 == 0) {
                newType = 1;
            }
            if (oldType != newType) {
                this.currentMasterPage.setType(newType);
            }
        }
    }
}

