/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.styles.paragraph;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.converter.core.styles.AbstractValueProvider;
import org.apache.poi.xwpf.converter.core.styles.XWPFStylesDocument;
import org.apache.poi.xwpf.converter.core.utils.StringUtils;
import org.apache.poi.xwpf.converter.core.utils.StylesHelper;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTDocDefaults;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTParaRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPrDefault;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTStyle;

public abstract class AbstractParagraphRunValueProvider<Value>
extends AbstractValueProvider<Value, XWPFParagraph> {
    public CTParaRPr getCTParaRPr(XWPFParagraph paragraph) {
        return paragraph.getCTP().getPPr().getRPr();
    }

    public CTRPr getRPr(CTStyle style) {
        return style.getRPr();
    }

    public CTRPr getRPr(CTDocDefaults docDefaults) {
        CTRPrDefault prDefault = docDefaults.getRPrDefault();
        if (prDefault == null) {
            return null;
        }
        return prDefault.getRPr();
    }

    @Override
    public Value getValueFromElement(XWPFParagraph paragraph) {
        return this.getValue(this.getCTParaRPr(paragraph));
    }

    @Override
    protected Value getValueFromStyle(CTStyle style) {
        return this.getValue(this.getRPr(style));
    }

    @Override
    protected Value getValueFromDocDefaultsStyle(CTDocDefaults docDefaults, XWPFStylesDocument stylesDocument) {
        return this.getValue(this.getRPr(docDefaults));
    }

    public abstract Value getValue(CTParaRPr var1);

    public abstract Value getValue(CTRPr var1);

    @Override
    protected String[] getStyleID(XWPFParagraph paragraph) {
        CTString style;
        List<String> styleIDs = StylesHelper.getStyleIDs(paragraph);
        CTParaRPr rPr = this.getCTParaRPr(paragraph);
        if (rPr != null && (style = rPr.getRStyle()) != null) {
            if (styleIDs == null) {
                styleIDs = new ArrayList<String>();
            }
            styleIDs.add(0, style.getVal());
        }
        if (styleIDs != null) {
            return styleIDs.toArray(StringUtils.EMPTY_STRING_ARRAY);
        }
        return null;
    }

    @Override
    protected CTStyle getDefaultStyle(XWPFParagraph element, XWPFStylesDocument styleManager) {
        return styleManager.getDefaultParagraphStyle();
    }
}

