/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.styles.table;

import org.apache.poi.xwpf.converter.core.TableWidth;
import org.apache.poi.xwpf.converter.core.styles.table.AbstractTableValueProvider;
import org.apache.poi.xwpf.converter.core.utils.DxaUtil;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblPrBase;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTblWidth;

public class TableWidthValueProvider
extends AbstractTableValueProvider<TableWidth> {
    public static final TableWidthValueProvider INSTANCE = new TableWidthValueProvider();

    @Override
    public TableWidth getValue(CTTblPr tblPr) {
        if (tblPr == null) {
            return null;
        }
        CTTblWidth tblWidth = tblPr.getTblW();
        return this.getTableWidth(tblWidth);
    }

    @Override
    public TableWidth getValue(CTTblPrBase tblPr) {
        CTTblWidth tblWidth = tblPr.getTblW();
        return this.getTableWidth(tblWidth);
    }

    public TableWidth getTableWidth(CTTblWidth tblWidth) {
        boolean percentUnit;
        if (tblWidth == null) {
            return null;
        }
        float width = tblWidth.getW().intValue();
        boolean bl = percentUnit = 2 == tblWidth.getType().intValue();
        width = percentUnit ? (width /= 100.0f) : DxaUtil.dxa2points(width);
        return new TableWidth(width, percentUnit);
    }
}

