/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.xwpf.converter.core.utils.StringUtils;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFTableCell;

public class StylesHelper {
    public static List<String> getStyleIDs(XWPFParagraph paragraph) {
        ArrayList<String> styleIDs = null;
        String paragraphStyleId = paragraph.getStyleID();
        boolean hasParagraphStyleId = StringUtils.isNotEmpty(paragraphStyleId);
        if (hasParagraphStyleId) {
            if (styleIDs == null) {
                styleIDs = new ArrayList<String>();
            }
            styleIDs.add(paragraphStyleId);
        }
        return styleIDs;
    }

    public static XWPFTableCell getEmbeddedTableCell(XWPFParagraph paragraph) {
        IBody body = paragraph.getBody();
        if (body != null && body.getPartType() == BodyType.TABLECELL) {
            return (XWPFTableCell)body;
        }
        return null;
    }
}

