/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.openxmlformats.styles.paragraph;

import java.math.BigInteger;
import org.apache.poi.xwpf.converter.core.ParagraphLineSpacing;
import org.apache.poi.xwpf.converter.core.openxmlformats.styles.paragraph.AbstractParagraphSpacingValueProvider;
import org.apache.poi.xwpf.converter.core.utils.DxaUtil;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParagraphLineSpacingValueProvider
extends AbstractParagraphSpacingValueProvider<ParagraphLineSpacing> {
    protected static final float LINE_SPACING_FACTOR = 240.0f;
    public static final ParagraphLineSpacingValueProvider INSTANCE = new ParagraphLineSpacingValueProvider();

    @Override
    protected ParagraphLineSpacing getValue(CTSpacing spacing) {
        Float lineHeight = null;
        Float lineMultiple = null;
        BigInteger line = spacing.getLine();
        if (line == null) {
            return null;
        }
        STLineSpacingRule.Enum lineRule = spacing.getLineRule();
        if (lineRule == null) {
            lineRule = STLineSpacingRule.AUTO;
        }
        if (lineRule == STLineSpacingRule.AUTO) {
            lineMultiple = Float.valueOf(line.floatValue() / 240.0f);
        } else {
            lineHeight = Float.valueOf(DxaUtil.dxa2points(line));
        }
        return new ParagraphLineSpacing(null, null, lineHeight, lineMultiple);
    }
}

