/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.pdf.internal.elements;

import fr.opensagres.xdocreport.itext.extension.IMasterPage;
import fr.opensagres.xdocreport.itext.extension.IMasterPageHeaderFooter;
import fr.opensagres.xdocreport.itext.extension.MasterPage;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.xwpf.converter.core.IXWPFMasterPage;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSectPr;

public class StylableMasterPage
extends MasterPage
implements IMasterPage,
IXWPFMasterPage<IMasterPageHeaderFooter> {
    private final CTSectPr sectPr;
    private int type;
    private final Map<Integer, IMasterPageHeaderFooter> headers;
    private final Map<Integer, IMasterPageHeaderFooter> footers;
    private IMasterPageHeaderFooter currentHeader;
    private IMasterPageHeaderFooter currentFooter;

    public StylableMasterPage(CTSectPr sectPr) {
        super(null);
        this.sectPr = sectPr;
        this.headers = new HashMap<Integer, IMasterPageHeaderFooter>();
        this.footers = new HashMap<Integer, IMasterPageHeaderFooter>();
    }

    public CTSectPr getSectPr() {
        return this.sectPr;
    }

    public boolean setType(int type) {
        this.type = type;
        boolean h = this.updateHeader(type);
        boolean f = this.updateFooter(type);
        return h || f;
    }

    private boolean updateHeader(int type) {
        IMasterPageHeaderFooter oldHeader = this.currentHeader;
        this.currentHeader = this.headers.get(type);
        if (this.currentHeader == null) {
            this.currentHeader = this.headers.get(2);
        }
        if (this.currentHeader == null) {
            return oldHeader != null;
        }
        return !this.currentHeader.equals(oldHeader);
    }

    private boolean updateFooter(int type) {
        IMasterPageHeaderFooter oldFooter = this.currentFooter;
        this.currentFooter = this.footers.get(type);
        if (this.currentFooter == null) {
            this.currentFooter = this.footers.get(2);
        }
        if (this.currentFooter == null) {
            return oldFooter != null;
        }
        return !this.currentFooter.equals(oldFooter);
    }

    public int getType() {
        return this.type;
    }

    public void setHeader(IMasterPageHeaderFooter header) {
        header.flush();
        if (!header.isEmpty()) {
            this.headers.put(this.type, header);
        }
    }

    public void setFooter(IMasterPageHeaderFooter footer) {
        footer.flush();
        if (!footer.isEmpty()) {
            this.footers.put(this.type, footer);
        }
    }

    public IMasterPageHeaderFooter getHeader() {
        return this.currentHeader;
    }

    public IMasterPageHeaderFooter getFooter() {
        return this.currentFooter;
    }
}

