/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.pdf.internal.elements;

import com.lowagie.text.Paragraph;
import fr.opensagres.xdocreport.itext.extension.ExtendedParagraph;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;
import java.awt.Color;
import java.math.BigInteger;
import org.apache.poi.xwpf.converter.core.utils.ColorHelper;
import org.apache.poi.xwpf.converter.pdf.internal.elements.StylableDocument;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;

public class StylableParagraph
extends ExtendedParagraph
implements IITextContainer {
    private static final long serialVersionUID = 664309269352903329L;
    private static final float DEFAULT_LINE_HEIGHT = 1.0f;
    private final StylableDocument ownerDocument;
    private IITextContainer parent;
    private String listItemText;

    public StylableParagraph(StylableDocument ownerDocument, IITextContainer parent) {
        this.ownerDocument = ownerDocument;
        this.parent = parent;
        super.setMultipliedLeading(1.0f);
    }

    public StylableParagraph(StylableDocument ownerDocument, Paragraph title, IITextContainer parent) {
        super(title);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
    }

    public IITextContainer getParent() {
        return this.parent;
    }

    public StylableDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    public void setBorder(CTBorder border, int borderSide) {
        boolean noBorder;
        if (border == null) {
            return;
        }
        boolean bl = noBorder = STBorder.NONE == border.getVal() || STBorder.NIL == border.getVal();
        if (noBorder) {
            return;
        }
        float size = -1.0f;
        BigInteger borderSize = border.getSz();
        if (borderSize != null) {
            size = borderSize.floatValue() / 8.0f;
        }
        Color borderColor = ColorHelper.getBorderColor((CTBorder)border);
        Float space = null;
        BigInteger borderSpace = border.getSpace();
        if (borderSpace != null) {
            space = Float.valueOf(borderSpace.floatValue());
        }
        switch (borderSide) {
            case 1: {
                if (size != -1.0f) {
                    this.setBorderWidthTop(size);
                }
                if (borderColor != null) {
                    super.setBorderColorTop(borderColor);
                }
                if (space == null) break;
                super.setBorderPaddingTop(space.floatValue());
                break;
            }
            case 2: {
                if (size != -1.0f) {
                    this.setBorderWidthBottom(size);
                }
                if (borderColor != null) {
                    super.setBorderColorBottom(borderColor);
                }
                if (space == null) break;
                super.setBorderPaddingBottom(space.floatValue());
                break;
            }
            case 4: {
                if (size != -1.0f) {
                    this.setBorderWidthLeft(size);
                }
                if (borderColor != null) {
                    super.setBorderColorLeft(borderColor);
                }
                if (space == null) break;
                super.setBorderPaddingLeft(space.floatValue());
                break;
            }
            case 8: {
                if (size != -1.0f) {
                    this.setBorderWidthRight(size);
                }
                if (borderColor != null) {
                    super.setBorderColorRight(borderColor);
                }
                if (space == null) break;
                super.setBorderPaddingRight(space.floatValue());
            }
        }
    }

    public String getListItemText() {
        return this.listItemText;
    }

    public void setListItemText(String listItemText) {
        this.listItemText = listItemText;
    }
}

