/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.xhtml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleContentHandler
extends DefaultHandler {
    private final OutputStream out;
    private final Writer writer;
    private boolean startingElement;
    private StringBuilder currentCharacters;
    private final Integer indent;
    private int nbElements;
    private boolean firstElement;

    public SimpleContentHandler(OutputStream out) {
        this(out, null);
    }

    public SimpleContentHandler(OutputStream out, Integer indent) {
        this(out, null, indent);
    }

    public SimpleContentHandler(Writer writer) {
        this(writer, null);
    }

    public SimpleContentHandler(Writer writer, Integer indent) {
        this(null, writer, indent);
    }

    private SimpleContentHandler(OutputStream out, Writer writer, Integer indent) {
        this.out = out;
        this.writer = writer;
        this.currentCharacters = new StringBuilder();
        this.indent = indent;
        this.firstElement = true;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (this.startingElement) {
            this.write(">");
        }
        if (this.currentCharacters.length() > 0) {
            this.flushCharacters(this.currentCharacters.toString());
            this.resetCharacters();
        }
        this.doIndentIfNeeded();
        this.write("<");
        this.write(localName);
        int length = attributes.getLength();
        if (length > 0) {
            String attrName = null;
            String attrValue = null;
            for (int i = 0; i < length; ++i) {
                attrName = attributes.getLocalName(i);
                attrValue = attributes.getValue(i);
                this.write(" ");
                this.write(attrName);
                this.write("=\"");
                this.write(attrValue);
                this.write("\"");
            }
        }
        this.startingElement = true;
        this.firstElement = false;
        ++this.nbElements;
    }

    private void doIndentIfNeeded() throws SAXException {
        if (this.indent == null || this.firstElement) {
            return;
        }
        StringBuilder content = new StringBuilder("\n");
        for (int i = 0; i < this.nbElements; ++i) {
            for (int j = 0; j < this.indent; ++j) {
                content.append(' ');
            }
        }
        this.write(content.toString());
    }

    @Override
    public final void endElement(String uri, String localName, String name) throws SAXException {
        --this.nbElements;
        if (this.currentCharacters.length() > 0) {
            this.flushCharacters(this.currentCharacters.toString());
            this.resetCharacters();
        }
        if (this.startingElement) {
            this.write("/>");
            this.startingElement = false;
        } else {
            this.doIndentIfNeeded();
            this.write("</");
            this.write(localName);
            this.write(">");
        }
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        if (this.startingElement) {
            this.write(">");
        }
        this.startingElement = false;
        for (int i = start; i < start + length; ++i) {
            char c = ch[i];
            this.currentCharacters.append(c);
        }
    }

    protected boolean mustEncodeCharachers() {
        return true;
    }

    private void flushCharacters(String characters) throws SAXException {
        this.write(characters);
    }

    protected void resetCharacters() {
        this.currentCharacters.setLength(0);
    }

    private void write(String content) throws SAXException {
        try {
            if (this.out != null) {
                this.out.write(content.getBytes());
            } else {
                this.writer.write(content);
            }
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
    }
}

