/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.odftoolkit.odfdom.converter.core.AbstractODFConverter;
import org.odftoolkit.odfdom.converter.core.IODFConverter;
import org.odftoolkit.odfdom.converter.core.ODFConverterException;
import org.odftoolkit.odfdom.converter.pdf.PdfOptions;
import org.odftoolkit.odfdom.converter.pdf.internal.ElementVisitorForIText;
import org.odftoolkit.odfdom.converter.pdf.internal.StyleEngineForIText;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeMasterStyles;
import org.odftoolkit.odfdom.pkg.ElementVisitor;
import org.odftoolkit.odfdom.pkg.OdfElement;

public class PdfConverter
extends AbstractODFConverter<PdfOptions> {
    private static final IODFConverter<PdfOptions> INSTANCE = new PdfConverter();

    public static IODFConverter<PdfOptions> getInstance() {
        return INSTANCE;
    }

    protected void doConvert(OdfDocument odfDocument, OutputStream out, Writer writer, PdfOptions options) throws ODFConverterException, IOException {
        try {
            StyleEngineForIText styleEngine = this.processStyles(odfDocument, options);
            ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
            ElementVisitorForIText visitorForIText = this.processBody(odfDocument, tempOut, styleEngine, options, null);
            Integer expectedPageCount = visitorForIText.getExpectedPageCount();
            int actualPageCount = visitorForIText.getActualPageCount();
            if (expectedPageCount == null || expectedPageCount == actualPageCount) {
                out.write(tempOut.toByteArray());
                out.close();
            } else {
                this.processBody(odfDocument, out, styleEngine, options, actualPageCount);
            }
        }
        catch (Exception e) {
            throw new ODFConverterException((Throwable)e);
        }
    }

    private StyleEngineForIText processStyles(OdfDocument odfDocument, PdfOptions options) throws Exception {
        StyleEngineForIText styleEngine = new StyleEngineForIText(odfDocument, options);
        OdfStylesDom stylesDom = odfDocument.getStylesDom();
        OdfContentDom contentDom = odfDocument.getContentDom();
        stylesDom.getOfficeStyles().accept((ElementVisitor)styleEngine);
        stylesDom.getAutomaticStyles().accept((ElementVisitor)styleEngine);
        contentDom.getAutomaticStyles().accept((ElementVisitor)styleEngine);
        return styleEngine;
    }

    private ElementVisitorForIText processBody(OdfDocument odfDocument, OutputStream out, StyleEngineForIText styleEngine, PdfOptions options, Integer forcedPageCount) throws Exception {
        ElementVisitorForIText visitorForIText = new ElementVisitorForIText(odfDocument, out, styleEngine, options, forcedPageCount);
        OdfOfficeMasterStyles masterStyles = odfDocument.getOfficeMasterStyles();
        OdfElement contentRoot = odfDocument.getContentRoot();
        masterStyles.accept((ElementVisitor)visitorForIText);
        contentRoot.accept((ElementVisitor)visitorForIText);
        visitorForIText.save();
        return visitorForIText;
    }
}

