/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.Element;
import com.lowagie.text.Font;
import fr.opensagres.xdocreport.itext.extension.ExtendedChunk;
import fr.opensagres.xdocreport.itext.extension.ExtendedDocument;
import java.awt.Color;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableElement;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableDocument;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTextProperties;

public class StylableChunk
extends ExtendedChunk
implements IStylableElement {
    private final IStylableContainer parent;
    private Style lastStyleApplied = null;

    public StylableChunk(StylableDocument ownerDocument, IStylableContainer parent, String textContent) {
        super((ExtendedDocument)ownerDocument, textContent);
        this.parent = parent;
    }

    @Override
    public void applyStyles(Style style) {
        this.lastStyleApplied = style;
        StyleTextProperties textProperties = style.getTextProperties();
        if (textProperties != null) {
            Float textRise;
            Color backgroundColor;
            Font font = textProperties.getFont();
            if (font != null) {
                super.setFont(font);
            }
            if ((backgroundColor = textProperties.getBackgroundColor()) != null) {
                super.setBackground(backgroundColor);
            }
            if ((textRise = textProperties.getTextPosition()) != null) {
                super.setTextRise(textRise.floatValue());
            }
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        return this;
    }
}

