/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.Phrase;
import com.lowagie.text.factories.RomanAlphabetFactory;
import com.lowagie.text.factories.RomanNumberFactory;
import java.util.ArrayList;
import java.util.Map;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableElement;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableDocument;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableListItem;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableParagraph;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleLineHeight;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleListProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleNumFormat;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleParagraphProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTextProperties;

public class StylableList
extends List
implements IStylableContainer {
    private IStylableContainer parent;
    private int listLevel;
    private boolean romanNumbered = false;
    private Style lastStyleApplied = null;

    public StylableList(StylableDocument ownerDocument, IStylableContainer parent, int listLevel) {
        this.parent = parent;
        this.listLevel = listLevel;
        super.setNumbered(false);
        super.setLettered(false);
        super.setLowercase(false);
        super.setPreSymbol("");
        super.setPostSymbol("");
        super.setListSymbol("");
        super.setAutoindent(false);
    }

    public int getIndex() {
        return this.first + this.list.size();
    }

    public void setFirst(int first) {
        this.first = first;
    }

    @Override
    public void addElement(Element element) {
        if (element instanceof StylableListItem) {
            StylableListItem li = (StylableListItem)element;
            boolean first = true;
            for (Element e : li.getElements()) {
                this.addElement(e, first);
                first = false;
            }
        }
    }

    private void addElement(Element element, boolean addLabel) {
        if (element instanceof Chunk) {
            Chunk ch = (Chunk)element;
            StylableParagraph p = new StylableParagraph(null, null);
            p.setFont(ch.getFont());
            p.addElement((Element)ch);
            element = p.getElement();
        }
        if (element instanceof Phrase) {
            StyleParagraphProperties paragraphProperties;
            StyleLineHeight lineHeightObj;
            IStylableElement stylableElement;
            Style style;
            Phrase p = (Phrase)element;
            StylableListItem li = new StylableListItem(p);
            Font symbolFont = this.symbol.getFont();
            if (symbolFont.isStandardFont()) {
                ArrayList chunks = p.getChunks();
                for (Chunk chunk : chunks) {
                    if (chunk.getFont().isStandardFont()) continue;
                    symbolFont = chunk.getFont();
                    break;
                }
                if (symbolFont.isStandardFont()) {
                    symbolFont = p.getFont();
                }
            }
            float lineHeight = 1.0f;
            boolean lineHeightProportional = true;
            if (element instanceof IStylableElement && (style = (stylableElement = (IStylableElement)element).getLastStyleApplied()) != null && (lineHeightObj = (paragraphProperties = style.getParagraphProperties()).getLineHeight()) != null && lineHeightObj.getLineHeight() != null) {
                lineHeight = lineHeightObj.getLineHeight().floatValue();
                lineHeightProportional = lineHeightObj.isLineHeightProportional();
            }
            if (addLabel) {
                if (this.numbered || this.lettered || this.romanNumbered) {
                    StringBuilder sbuf = new StringBuilder(this.preSymbol);
                    int index = this.first + this.list.size();
                    if (this.lettered) {
                        sbuf.append(RomanAlphabetFactory.getString((int)index, (boolean)this.lowercase));
                    } else if (this.romanNumbered) {
                        sbuf.append(RomanNumberFactory.getString((int)index, (boolean)this.lowercase));
                    } else {
                        sbuf.append(index);
                    }
                    sbuf.append(this.postSymbol);
                    li.setListSymbol(sbuf.toString(), symbolFont, lineHeight, lineHeightProportional);
                } else {
                    li.setListSymbol(this.symbol.getContent(), symbolFont, lineHeight, lineHeightProportional);
                }
            } else {
                li.setListSymbol("", symbolFont, lineHeight, lineHeightProportional);
            }
            li.setIndentationLeft(this.symbolIndent);
            li.setIndentationRight(0.0f);
            this.list.add(li);
        } else if (element instanceof List) {
            List l = (List)element;
            l.setIndentationLeft(l.getIndentationLeft() - this.getIndentationLeft());
            --this.first;
            this.list.add(l);
        }
    }

    public static StyleListProperties getListProperties(Map<Integer, StyleListProperties> listPropertiesMap, int level) {
        StyleListProperties listProperties = null;
        for (int i = level; i >= 0 && listProperties == null; --i) {
            listProperties = listPropertiesMap.get(i);
        }
        return listProperties;
    }

    @Override
    public void applyStyles(Style style) {
        StyleListProperties listProperties;
        this.lastStyleApplied = style;
        Map<Integer, StyleListProperties> listPropertiesMap = style.getListPropertiesMap();
        if (listPropertiesMap != null && (listProperties = StylableList.getListProperties(listPropertiesMap, this.listLevel)) != null) {
            Image image;
            String bulletChar = listProperties.getBulletChar();
            if (bulletChar != null) {
                Font font;
                Chunk symbol = new Chunk(bulletChar);
                StyleTextProperties textProperties = listProperties.getTextProperties();
                if (textProperties != null && (font = textProperties.getFont()) != null) {
                    symbol.setFont(font);
                }
                super.setListSymbol(symbol);
            }
            if ((image = listProperties.getImage()) != null) {
                Float height;
                Float width = listProperties.getWidth();
                if (width != null) {
                    image.scaleAbsoluteWidth(width.floatValue());
                }
                if ((height = listProperties.getHeight()) != null) {
                    image.scaleAbsoluteHeight(height.floatValue());
                }
                super.setListSymbol(new Chunk(image, 0.0f, 0.0f));
            }
            if (bulletChar == null && image == null) {
                StyleNumFormat numFormat;
                Integer startValue;
                Font font;
                Chunk symbol = new Chunk("");
                StyleTextProperties textProperties = listProperties.getTextProperties();
                if (textProperties != null && (font = textProperties.getFont()) != null) {
                    symbol.setFont(font);
                }
                if ((startValue = listProperties.getStartValue()) != null) {
                    super.setFirst(startValue.intValue());
                }
                if ((numFormat = listProperties.getNumFormat()) != null) {
                    String numSuffix;
                    String numPrefix = listProperties.getNumPrefix();
                    if (numPrefix != null) {
                        super.setPreSymbol(numPrefix);
                        symbol = new Chunk(numPrefix, symbol.getFont());
                    }
                    if ((numSuffix = listProperties.getNumSuffix()) != null) {
                        super.setPostSymbol(numSuffix);
                        symbol.append(numSuffix);
                    }
                    super.setNumbered(true);
                    super.setLettered(numFormat.isAlphabetical());
                    this.romanNumbered = numFormat.isRoman();
                    super.setLowercase(numFormat.isLowercase());
                }
                super.setListSymbol(symbol);
            }
            Float marginLeft = listProperties.getMarginLeft();
            Float textIndent = listProperties.getTextIndent();
            Float spaceBefore = listProperties.getSpaceBefore();
            Float minLabelWidth = listProperties.getMinLabelWidth();
            if (marginLeft != null && textIndent != null) {
                super.setIndentationLeft(Math.max(marginLeft.floatValue() + textIndent.floatValue(), 0.0f));
                super.setSymbolIndent(Math.max(-textIndent.floatValue(), 0.0f));
            } else if (spaceBefore != null && minLabelWidth != null) {
                super.setIndentationLeft(Math.max(spaceBefore.floatValue(), 0.0f));
                super.setSymbolIndent(Math.max(minLabelWidth.floatValue(), 0.0f));
            }
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    @Override
    public Element getElement() {
        return this;
    }
}

