/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import fr.opensagres.xdocreport.itext.extension.ExtendedParagraph;
import java.awt.Color;
import java.util.ArrayList;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IBreakHandlingContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableDocument;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableDocumentSection;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StyleUtils;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleBorder;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleBreak;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleLineHeight;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleParagraphProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTextProperties;

public class StylableParagraph
extends ExtendedParagraph
implements IStylableContainer {
    private static final long serialVersionUID = 664309269352903329L;
    public static final float DEFAULT_LINE_HEIGHT = 1.0f;
    private final StylableDocument ownerDocument;
    private IStylableContainer parent;
    private Style lastStyleApplied = null;
    private boolean elementPostProcessed = false;

    public StylableParagraph(StylableDocument ownerDocument, IStylableContainer parent) {
        this.ownerDocument = ownerDocument;
        this.parent = parent;
        super.setMultipliedLeading(1.0f);
    }

    public StylableParagraph(StylableDocument ownerDocument, Paragraph title, IStylableContainer parent) {
        super(title);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
        super.setMultipliedLeading(1.0f);
    }

    @Override
    public void applyStyles(Style style) {
        StyleParagraphProperties paragraphProperties;
        Font font;
        this.lastStyleApplied = style;
        StyleTextProperties textProperties = style.getTextProperties();
        if (textProperties != null && (font = textProperties.getFont()) != null) {
            super.setFont(font);
        }
        if ((paragraphProperties = style.getParagraphProperties()) != null) {
            StyleBorder borderBottom;
            StyleBorder borderTop;
            StyleBorder borderRight;
            StyleBorder borderLeft;
            StyleBorder border;
            Color backgroundColor;
            Boolean keepTogether;
            Boolean autoTextIndent;
            Float marginBottom;
            Float marginTop;
            Float marginRight;
            Float marginLeft;
            Float margin;
            int alignment;
            StyleBreak breakBefore = paragraphProperties.getBreakBefore();
            if (breakBefore != null) {
                this.handleBreak(breakBefore);
            }
            if ((alignment = paragraphProperties.getAlignment()) != -1) {
                super.setAlignment(alignment);
            }
            if ((margin = paragraphProperties.getMargin()) != null) {
                super.setIndentationLeft(margin.floatValue());
                super.setIndentationRight(margin.floatValue());
                super.setSpacingBefore(margin.floatValue());
                super.setSpacingAfter(margin.floatValue());
            }
            if ((marginLeft = paragraphProperties.getMarginLeft()) != null) {
                super.setIndentationLeft(marginLeft.floatValue());
            }
            if ((marginRight = paragraphProperties.getMarginRight()) != null) {
                super.setIndentationRight(marginRight.floatValue());
            }
            if ((marginTop = paragraphProperties.getMarginTop()) != null) {
                super.setSpacingBefore(marginTop.floatValue());
            }
            if ((marginBottom = paragraphProperties.getMarginBottom()) != null) {
                super.setSpacingAfter(marginBottom.floatValue());
            }
            if (Boolean.TRUE.equals(autoTextIndent = paragraphProperties.getAutoTextIndent())) {
                float fontSize = this.font != null ? this.font.getCalculatedSize() : 12.0f;
                super.setFirstLineIndent(1.3f * fontSize);
            } else {
                Float textIndent = paragraphProperties.getTextIndent();
                if (textIndent != null && textIndent.floatValue() > 0.0f) {
                    super.setFirstLineIndent(textIndent.floatValue());
                }
            }
            StyleLineHeight lineHeight = paragraphProperties.getLineHeight();
            if (lineHeight != null && lineHeight.getLineHeight() != null) {
                if (lineHeight.isLineHeightProportional()) {
                    super.setMultipliedLeading(lineHeight.getLineHeight().floatValue());
                } else {
                    super.setLeading(lineHeight.getLineHeight().floatValue());
                }
            }
            if ((keepTogether = paragraphProperties.getKeepTogether()) != null) {
                super.setKeepTogether(keepTogether.booleanValue());
            }
            if ((backgroundColor = paragraphProperties.getBackgroundColor()) != null && !Color.WHITE.equals(backgroundColor)) {
                super.setBackgroundColor(backgroundColor);
            }
            if ((border = paragraphProperties.getBorder()) != null && !border.isNoBorder()) {
                StyleUtils.applyStyles(border, this.getWrapperCell());
            }
            if ((borderLeft = paragraphProperties.getBorderLeft()) != null && !borderLeft.isNoBorder()) {
                StyleUtils.applyStyles(borderLeft, this.getWrapperCell());
            }
            if ((borderRight = paragraphProperties.getBorderRight()) != null && !borderRight.isNoBorder()) {
                StyleUtils.applyStyles(borderRight, this.getWrapperCell());
            }
            if ((borderTop = paragraphProperties.getBorderTop()) != null && !borderTop.isNoBorder()) {
                StyleUtils.applyStyles(borderTop, this.getWrapperCell());
            }
            if ((borderBottom = paragraphProperties.getBorderBottom()) != null && !borderBottom.isNoBorder()) {
                StyleUtils.applyStyles(borderBottom, this.getWrapperCell());
            }
        }
    }

    private void handleBreak(StyleBreak styleBreak) {
        IBreakHandlingContainer b;
        if ((styleBreak.isColumnBreak() || styleBreak.isPageBreak()) && (b = StylableDocumentSection.getIBreakHandlingContainer(this.parent)) != null) {
            if (styleBreak.isColumnBreak()) {
                b.columnBreak();
            } else if (styleBreak.isPageBreak()) {
                b.pageBreak();
            }
        }
    }

    @Override
    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    @Override
    public IStylableContainer getParent() {
        return this.parent;
    }

    public StylableDocument getOwnerDocument() {
        return this.ownerDocument;
    }

    public static Chunk createAdjustedChunk(String content, Font font, float lineHeight, boolean lineHeightProportional) {
        StylableParagraph p = new StylableParagraph(null, null);
        p.setFont(font);
        if (lineHeightProportional) {
            p.setMultipliedLeading(lineHeight);
        } else {
            p.setLeading(lineHeight);
        }
        p.addElement((Element)new Chunk(content, font));
        p.getElement();
        return (Chunk)p.getChunks().get(0);
    }

    @Override
    public Element getElement() {
        if (!this.elementPostProcessed) {
            this.elementPostProcessed = true;
            boolean empty = true;
            ArrayList chunks = this.getChunks();
            for (Chunk chunk : chunks) {
                if (chunk.getImage() != null || chunk.getContent() == null || chunk.getContent().length() <= 0) continue;
                empty = false;
                break;
            }
            if (empty) {
                super.add((Object)new Chunk("\t"));
            }
            if ((chunks = this.getChunks()).size() > 0) {
                Chunk lastChunk = (Chunk)chunks.get(chunks.size() - 1);
                String localDestination = null;
                if (lastChunk.getAttributes() != null) {
                    localDestination = (String)lastChunk.getAttributes().get("LOCALDESTINATION");
                }
                if (localDestination != null) {
                    super.add((Object)new Chunk("\u00a0"));
                }
            }
            if (this.font != null && this.font.getBaseFont() != null) {
                float size = this.font.getSize();
                float ascender = this.font.getBaseFont().getFontDescriptor(9, size);
                float descender = -this.font.getBaseFont().getFontDescriptor(10, size);
                float margin = this.font.getBaseFont().getFontDescriptor(11, size);
                float multiplier = (ascender + descender + margin) / size;
                if (this.multipliedLeading > 0.0f) {
                    this.setMultipliedLeading(this.getMultipliedLeading() * multiplier);
                }
                float itextdescender = -this.font.getBaseFont().getFontDescriptor(3, size);
                float textRise = itextdescender + this.getTotalLeading() - this.font.getSize() * multiplier;
                chunks = this.getChunks();
                for (Chunk chunk : chunks) {
                    Font f = chunk.getFont();
                    if (f != null) {
                        float s = f.getSize();
                        if (f.isUnderlined()) {
                            f.setStyle(f.getStyle() & 0xFFFFFFFB);
                            chunk.setUnderline(s * 1.0f / 17.0f, s * -1.0f / 7.0f + textRise);
                        }
                        if (f.isStrikethru()) {
                            f.setStyle(f.getStyle() & 0xFFFFFFF7);
                            chunk.setUnderline(s * 1.0f / 17.0f, s * 1.0f / 4.0f + textRise);
                        }
                    }
                    chunk.setTextRise(chunk.getTextRise() + textRise);
                }
            }
        }
        return super.getElement();
    }
}

