/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.draw.DrawInterface;
import java.util.List;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableElement;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableDocument;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableParagraph;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleLineHeight;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleParagraphProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTabStopProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTextProperties;

public class StylableTab
implements IStylableElement,
DrawInterface {
    private IStylableContainer parent;
    private boolean inTableOfContent;
    private Style lastStyleApplied = null;
    private Font font = new Font();
    private float lineHeight = 1.0f;
    private boolean lineHeightProportional = true;
    private String leaderText = " ";
    private Chunk chunk;

    public StylableTab(StylableDocument ownerDocument, IStylableContainer parent, boolean inTableOfContent) {
        this.parent = parent;
        this.inTableOfContent = inTableOfContent;
    }

    public void applyStyles(Style style) {
        StyleTabStopProperties tabStopProperties;
        String leaderText;
        List<StyleTabStopProperties> tabStopPropertiesList;
        StyleLineHeight lineHeight;
        StyleParagraphProperties paragraphProperties;
        Font font;
        this.lastStyleApplied = style;
        StyleTextProperties textProperties = style.getTextProperties();
        if (textProperties != null && (font = textProperties.getFont()) != null) {
            this.font = font;
        }
        if ((paragraphProperties = style.getParagraphProperties()) != null && (lineHeight = paragraphProperties.getLineHeight()) != null && lineHeight.getLineHeight() != null) {
            this.lineHeight = lineHeight.getLineHeight().floatValue();
            this.lineHeightProportional = lineHeight.isLineHeightProportional();
        }
        if ((tabStopPropertiesList = style.getTabStopPropertiesList()) != null && !tabStopPropertiesList.isEmpty() && (leaderText = (tabStopProperties = tabStopPropertiesList.get(0)).getLeaderText()) != null) {
            this.leaderText = leaderText;
        }
    }

    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    public IStylableContainer getParent() {
        return this.parent;
    }

    public Element getElement() {
        if (this.chunk == null) {
            this.chunk = this.inTableOfContent ? new Chunk((DrawInterface)this) : new Chunk(this.leaderText, this.font);
        }
        return this.chunk;
    }

    public void draw(PdfContentByte canvas, float llx, float lly, float urx, float ury, float y) {
        if (this.font.getBaseFont() != null && (double)this.font.getSize() > 0.0 && this.leaderText.trim().length() > 0) {
            Chunk tmp;
            float width = urx - llx;
            String txt = "";
            while ((tmp = new Chunk(txt + this.leaderText, this.font)).getWidthPoint() <= width) {
                txt = txt + this.leaderText;
            }
            float xoffset = width - new Chunk(txt, this.font).getWidthPoint();
            Chunk tmp2 = StylableParagraph.createAdjustedChunk(txt, this.font, this.lineHeight, this.lineHeightProportional);
            float yoffset = tmp2.getTextRise();
            canvas.saveState();
            canvas.beginText();
            canvas.setFontAndSize(this.font.getBaseFont(), this.font.getSize());
            canvas.showTextAligned(0, txt, llx + xoffset, y + yoffset, 0.0f);
            canvas.endText();
            canvas.restoreState();
        }
    }
}

