/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.styles;

import fr.opensagres.xdocreport.itext.extension.font.IFontProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleColumnProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleGraphicProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleHeaderFooterProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleListProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StylePageLayoutProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleParagraphProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleSectionProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTabStopProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTableCellProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTableProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTableRowProperties;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleTextProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Style {
    private final String styleName;
    private final String familyName;
    private String masterPageName;
    private StylePageLayoutProperties pageLayoutProperties;
    private StyleHeaderFooterProperties headerProperties;
    private StyleHeaderFooterProperties footerProperties;
    private StyleParagraphProperties paragraphProperties;
    private List<StyleTabStopProperties> tabStopPropertiesList;
    private StyleTextProperties textProperties;
    private StyleTableProperties tableProperties;
    private StyleTableRowProperties tableRowProperties;
    private StyleTableCellProperties tableCellProperties;
    private StyleGraphicProperties graphicProperties;
    private Map<Integer, StyleListProperties> listPropertiesMap;
    private Map<Integer, StyleListProperties> outlinePropertiesMap;
    private StyleSectionProperties sectionProperties;
    private List<StyleColumnProperties> columnPropertiesList;
    private final IFontProvider fontProvider;

    public Style(IFontProvider fontProvider, String styleName, String familyName, String masterPageName) {
        this.styleName = styleName;
        this.familyName = familyName;
        this.masterPageName = masterPageName;
        this.fontProvider = fontProvider;
    }

    public void merge(Style style, boolean fullPropagation) {
        if (fullPropagation) {
            if (style.getPageLayoutProperties() != null) {
                this.pageLayoutProperties = style.getPageLayoutProperties();
            }
            if (style.getHeaderProperties() != null) {
                this.headerProperties = style.getHeaderProperties();
            }
            if (style.getFooterProperties() != null) {
                this.footerProperties = style.getFooterProperties();
            }
            if (style.getTabStopPropertiesList() != null) {
                this.tabStopPropertiesList = new ArrayList<StyleTabStopProperties>(style.getTabStopPropertiesList());
                this.tabStopPropertiesList = Collections.unmodifiableList(this.tabStopPropertiesList);
            }
            if (style.getListPropertiesMap() != null) {
                this.listPropertiesMap = new HashMap<Integer, StyleListProperties>(style.getListPropertiesMap());
                this.listPropertiesMap = Collections.unmodifiableMap(this.listPropertiesMap);
            }
            if (style.getOutlinePropertiesMap() != null) {
                this.outlinePropertiesMap = new HashMap<Integer, StyleListProperties>(style.getOutlinePropertiesMap());
                this.outlinePropertiesMap = Collections.unmodifiableMap(this.outlinePropertiesMap);
            }
            if (style.getSectionProperties() != null) {
                this.sectionProperties = style.getSectionProperties();
            }
            if (style.getColumnPropertiesList() != null) {
                this.columnPropertiesList = new ArrayList<StyleColumnProperties>(style.getColumnPropertiesList());
                this.columnPropertiesList = Collections.unmodifiableList(this.columnPropertiesList);
            }
        }
        if (this.paragraphProperties == null) {
            if (style.getParagraphProperties() != null) {
                this.paragraphProperties = new StyleParagraphProperties(style.getParagraphProperties());
            }
        } else if (style.getParagraphProperties() != null) {
            this.paragraphProperties.merge(style.getParagraphProperties());
        }
        if (this.textProperties == null) {
            if (style.getTextProperties() != null) {
                this.textProperties = new StyleTextProperties(this.fontProvider, style.getTextProperties());
            }
        } else if (style.getTextProperties() != null) {
            this.textProperties.merge(style.getTextProperties());
        }
        if (this.tableProperties == null) {
            if (style.getTableProperties() != null) {
                this.tableProperties = new StyleTableProperties(style.getTableProperties());
            }
        } else if (style.getTableProperties() != null) {
            this.tableProperties.merge(style.getTableProperties());
        }
        if (this.tableRowProperties == null) {
            if (style.getTableRowProperties() != null) {
                this.tableRowProperties = new StyleTableRowProperties(style.getTableRowProperties());
            }
        } else if (style.getTableRowProperties() != null) {
            this.tableRowProperties.merge(style.getTableRowProperties());
        }
        if (this.tableCellProperties == null) {
            if (style.getTableCellProperties() != null) {
                this.tableCellProperties = new StyleTableCellProperties(style.getTableCellProperties());
            }
        } else if (style.getTableCellProperties() != null) {
            this.tableCellProperties.merge(style.getTableCellProperties());
        }
        if (this.graphicProperties == null) {
            if (style.getGraphicProperties() != null) {
                this.graphicProperties = new StyleGraphicProperties(style.getGraphicProperties());
            }
        } else if (style.getGraphicProperties() != null) {
            this.graphicProperties.merge(style.getGraphicProperties());
        }
    }

    public String getStyleName() {
        return this.styleName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getMasterPageName() {
        return this.masterPageName;
    }

    public StylePageLayoutProperties getPageLayoutProperties() {
        return this.pageLayoutProperties;
    }

    public void setPageLayoutProperties(StylePageLayoutProperties pageLayoutProperties) {
        this.pageLayoutProperties = pageLayoutProperties;
    }

    public StyleHeaderFooterProperties getHeaderProperties() {
        return this.headerProperties;
    }

    public void setHeaderProperties(StyleHeaderFooterProperties headerProperties) {
        this.headerProperties = headerProperties;
    }

    public StyleHeaderFooterProperties getFooterProperties() {
        return this.footerProperties;
    }

    public void setFooterProperties(StyleHeaderFooterProperties footerProperties) {
        this.footerProperties = footerProperties;
    }

    public StyleParagraphProperties getParagraphProperties() {
        return this.paragraphProperties;
    }

    public void setParagraphProperties(StyleParagraphProperties paragraphProperties) {
        this.paragraphProperties = paragraphProperties;
    }

    public List<StyleTabStopProperties> getTabStopPropertiesList() {
        return this.tabStopPropertiesList;
    }

    public void setTabStopPropertiesList(List<StyleTabStopProperties> tabStopPropertiesList) {
        this.tabStopPropertiesList = tabStopPropertiesList;
    }

    public StyleTextProperties getTextProperties() {
        return this.textProperties;
    }

    public void setTextProperties(StyleTextProperties textProperties) {
        this.textProperties = textProperties;
    }

    public StyleTableProperties getTableProperties() {
        return this.tableProperties;
    }

    public void setTableProperties(StyleTableProperties tableProperties) {
        this.tableProperties = tableProperties;
    }

    public StyleTableRowProperties getTableRowProperties() {
        return this.tableRowProperties;
    }

    public void setTableRowProperties(StyleTableRowProperties tableRowProperties) {
        this.tableRowProperties = tableRowProperties;
    }

    public StyleTableCellProperties getTableCellProperties() {
        return this.tableCellProperties;
    }

    public void setTableCellProperties(StyleTableCellProperties tableCellProperties) {
        this.tableCellProperties = tableCellProperties;
    }

    public StyleGraphicProperties getGraphicProperties() {
        return this.graphicProperties;
    }

    public void setGraphicProperties(StyleGraphicProperties graphicProperties) {
        this.graphicProperties = graphicProperties;
    }

    public Map<Integer, StyleListProperties> getListPropertiesMap() {
        return this.listPropertiesMap;
    }

    public void setListPropertiesMap(Map<Integer, StyleListProperties> listPropertiesMap) {
        this.listPropertiesMap = listPropertiesMap;
    }

    public Map<Integer, StyleListProperties> getOutlinePropertiesMap() {
        return this.outlinePropertiesMap;
    }

    public void setOutlinePropertiesMap(Map<Integer, StyleListProperties> outlinePropertiesMap) {
        this.outlinePropertiesMap = outlinePropertiesMap;
    }

    public StyleSectionProperties getSectionProperties() {
        return this.sectionProperties;
    }

    public void setSectionProperties(StyleSectionProperties sectionProperties) {
        this.sectionProperties = sectionProperties;
    }

    public List<StyleColumnProperties> getColumnPropertiesList() {
        return this.columnPropertiesList;
    }

    public void setColumnPropertiesList(List<StyleColumnProperties> columnPropertiesList) {
        this.columnPropertiesList = columnPropertiesList;
    }
}

