/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.pdf.internal.stylable;

import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.Image;
import fr.opensagres.xdocreport.itext.extension.ExtendedImage;
import java.util.zip.Inflater;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableContainer;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.IStylableElement;
import org.odftoolkit.odfdom.converter.pdf.internal.stylable.StylableDocument;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.Style;
import org.odftoolkit.odfdom.converter.pdf.internal.styles.StyleGraphicProperties;

public class StylableImage
implements IStylableElement {
    private IStylableContainer parent;
    private Image image;
    private Float x;
    private Float y;
    private boolean runThrough;
    private Chunk chunk;
    private Style lastStyleApplied = null;

    public StylableImage(StylableDocument ownerDocument, IStylableContainer parent, Image image, Float x, Float y, Float width, Float height) {
        this.parent = parent;
        this.image = image;
        this.x = x;
        this.y = y;
        if (width != null) {
            image.scaleAbsoluteWidth(width.floatValue());
        }
        if (height != null) {
            image.scaleAbsoluteHeight(height.floatValue());
        }
    }

    public void applyStyles(Style style) {
        this.lastStyleApplied = style;
        StyleGraphicProperties graphicProperties = style.getGraphicProperties();
        if (graphicProperties != null) {
            this.runThrough = Boolean.TRUE.equals(graphicProperties.getRunThrough());
        }
    }

    public Style getLastStyleApplied() {
        return this.lastStyleApplied;
    }

    public IStylableContainer getParent() {
        return this.parent;
    }

    public Element getElement() {
        if (this.chunk == null) {
            float offsetX = this.x != null ? this.x.floatValue() : 0.0f;
            float offsetY = this.y != null ? -this.y.floatValue() : 0.0f;
            ExtendedImage extImg = new ExtendedImage(this.image, offsetY);
            this.chunk = new Chunk((Image)extImg, offsetX, this.runThrough ? -this.image.getScaledHeight() : 0.0f);
        }
        return this.chunk;
    }

    public static Image getImage(byte[] imgb) {
        try {
            int bmpStartOffset;
            if (imgb.length >= 6 && imgb[0] == 86 && imgb[1] == 67 && imgb[2] == 76 && imgb[3] == 77 && imgb[4] == 84 && imgb[5] == 70 && (bmpStartOffset = StylableImage.getBmpStartOffset(imgb)) >= 0) {
                int ZCOMPRESS;
                int bmpFileSize = StylableImage.getInt(imgb, bmpStartOffset + 2);
                byte[] bmpb = new byte[bmpFileSize];
                int bmpHeaderSize = 14;
                int compressionMethod = StylableImage.getInt(imgb, bmpStartOffset + bmpHeaderSize + 16);
                if (compressionMethod == (ZCOMPRESS = 16794707)) {
                    int dibHeaderSize = StylableImage.getInt(imgb, bmpStartOffset + bmpHeaderSize);
                    int allHeadersSize = bmpHeaderSize + dibHeaderSize;
                    int compressedSize = StylableImage.getInt(imgb, bmpStartOffset + allHeadersSize);
                    int uncompressedSize = StylableImage.getInt(imgb, bmpStartOffset + allHeadersSize + 4);
                    Inflater inflater = new Inflater();
                    inflater.setInput(imgb, bmpStartOffset + allHeadersSize + 12, compressedSize);
                    byte[] uncompressedData = new byte[uncompressedSize];
                    inflater.inflate(uncompressedData);
                    System.arraycopy(imgb, bmpStartOffset, bmpb, 0, allHeadersSize);
                    System.arraycopy(imgb, bmpStartOffset + allHeadersSize + 8, bmpb, bmpHeaderSize + 16, 4);
                    System.arraycopy(uncompressedData, 0, bmpb, allHeadersSize, uncompressedSize);
                } else {
                    System.arraycopy(imgb, bmpStartOffset, bmpb, 0, bmpFileSize);
                }
                imgb = bmpb;
            }
            return Image.getInstance((byte[])imgb);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static int getBmpStartOffset(byte[] imgb) {
        for (int i = 0; i < imgb.length - 1; ++i) {
            if (imgb[i] != 66 || imgb[i + 1] != 77) continue;
            return i;
        }
        return -1;
    }

    private static int getInt(byte[] blob, int pos) {
        return (blob[pos + 0] & 0xFF) + ((blob[pos + 1] & 0xFF) << 8) + ((blob[pos + 2] & 0xFF) << 16) + ((blob[pos + 3] & 0xFF) << 24);
    }
}

