/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.converter.internal.xhtml;

import fr.opensagres.xdocreport.xhtml.extension.CSSStylePropertyConstants;
import fr.opensagres.xdocreport.xhtml.extension.CSSStyleSheet;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLConstants;
import fr.opensagres.xdocreport.xhtml.extension.XHTMLPageContentBuffer;
import java.util.HashMap;
import java.util.Map;
import org.odftoolkit.odfdom.converter.core.AbstractStyleEngine;
import org.odftoolkit.odfdom.converter.core.IURIResolver;
import org.odftoolkit.odfdom.converter.core.utils.StringUtils;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeAutomaticStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeMasterStylesElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeStylesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleDefaultStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleFooterStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleGraphicPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderFooterPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleHeaderStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutElement;
import org.odftoolkit.odfdom.dom.element.style.StylePageLayoutPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleStyleElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableColumnPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTablePropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.w3c.dom.Node;

public class StyleEngineForXHTML
extends AbstractStyleEngine
implements XHTMLConstants,
CSSStylePropertyConstants {
    private static final String STYLE_NAME_HEADER = "Header";
    private static final String STYLE_NAME_FOOTER = "Footer";
    private CSSStyleSheet cssStyleSheet;
    private final boolean generateCSSComments;
    private final Map<String, String> classNamesMap = new HashMap<String, String>();
    private final IURIResolver resolver;

    public StyleEngineForXHTML(OdfDocument odfDocument, boolean generateCSSComments, int indent, IURIResolver resolver) {
        super(odfDocument);
        this.generateCSSComments = generateCSSComments;
        this.resolver = resolver;
        this.cssStyleSheet = new CSSStyleSheet(indent);
    }

    public void visit(OfficeStylesElement ele) {
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:styles begin");
        }
        super.visit(ele);
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:styles end");
        }
    }

    public void visit(OfficeAutomaticStylesElement ele) {
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:automatic-styles begin");
        }
        super.visit(ele);
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:automatic-styles end");
        }
    }

    public void visit(OfficeMasterStylesElement ele) {
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:master-styles begin");
        }
        super.visit(ele);
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("office:master-styles end");
        }
    }

    public void visit(StyleDefaultStyleElement ele) {
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:default-style @style:family=" + ele.getFamilyName() + " begin");
        }
        this.cssStyleSheet.startCSSStyleDeclaration(this.computeCSSClassName((OdfStyleBase)ele));
        super.visit(ele);
        this.cssStyleSheet.endCSSStyleDeclaration();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:default-style @style:family=" + ele.getFamilyName() + " end");
        }
    }

    public void visit(StyleStyleElement ele) {
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:style @style:name= " + ele.getStyleNameAttribute() + ", @style:family=" + ele.getFamilyName() + " begin");
        }
        this.cssStyleSheet.startCSSStyleDeclaration(this.computeCSSClassName((OdfStyleBase)ele));
        super.visit(ele);
        this.cssStyleSheet.endCSSStyleDeclaration();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:style @style:name= " + ele.getStyleNameAttribute() + ", @style:family=" + ele.getFamilyName() + " end");
        }
    }

    public void visit(StylePageLayoutElement ele) {
        super.visit(ele);
    }

    public void visit(StylePageLayoutPropertiesElement ele) {
        String width;
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String styleName = null;
        String styleFamilyName = null;
        StylePageLayoutElement styleBase = null;
        Node parentNode = ele.getParentNode();
        if (!(parentNode instanceof StylePageLayoutElement)) {
            return;
        }
        styleName = ((StylePageLayoutElement)parentNode).getStyleNameAttribute();
        styleFamilyName = ((StylePageLayoutElement)parentNode).getFamilyName();
        styleBase = (StylePageLayoutElement)parentNode;
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:page-layout-properties @style:page-layout-name= " + styleName + ", @style:family=" + styleFamilyName + " begin");
        }
        this.cssStyleSheet.startCSSStyleDeclaration(this.computeCSSClassName((OdfStyleBase)styleBase));
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty((String)backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty((String)(border = ele.getFoBorderAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border", border);
        }
        if (StringUtils.isNotEmpty((String)(borderBottom = ele.getFoBorderBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-bottom", borderBottom);
        }
        if (StringUtils.isNotEmpty((String)(borderLeft = ele.getFoBorderLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-left", borderLeft);
        }
        if (StringUtils.isNotEmpty((String)(borderRight = ele.getFoBorderRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-right", borderRight);
        }
        if (StringUtils.isNotEmpty((String)(borderTop = ele.getFoBorderTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-top", borderTop);
        }
        if (StringUtils.isNotEmpty((String)(margin = ele.getFoMarginAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin", margin);
        }
        if (StringUtils.isNotEmpty((String)(marginBottom = ele.getFoMarginBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-bottom", marginBottom);
        }
        if (StringUtils.isNotEmpty((String)(marginLeft = ele.getFoMarginLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-left", marginLeft);
        }
        if (StringUtils.isNotEmpty((String)(marginRight = ele.getFoMarginRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-right", marginRight);
        }
        if (StringUtils.isNotEmpty((String)(marginTop = ele.getFoMarginTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-top", marginTop);
        }
        if (StringUtils.isNotEmpty((String)(padding = ele.getFoPaddingAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding", padding);
        }
        if (StringUtils.isNotEmpty((String)(paddingBottom = ele.getFoPaddingBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-bottom", paddingBottom);
        }
        if (StringUtils.isNotEmpty((String)(paddingLeft = ele.getFoPaddingLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-left", paddingLeft);
        }
        if (StringUtils.isNotEmpty((String)(paddingRight = ele.getFoPaddingRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-right", paddingRight);
        }
        if (StringUtils.isNotEmpty((String)(paddingTop = ele.getFoPaddingTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-top", paddingTop);
        }
        if (StringUtils.isNotEmpty((String)(width = ele.getFoPageWidthAttribute()))) {
            this.cssStyleSheet.setCSSProperty("width", width);
        }
        super.visit(ele);
        this.cssStyleSheet.endCSSStyleDeclaration();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:page-layout-properties @style:page-layout-name=" + styleName + ", @style:family=" + styleFamilyName + " end");
        }
    }

    public void visit(StyleHeaderStyleElement ele) {
        StylePageLayoutElement stylePageLayout = (StylePageLayoutElement)ele.getParentNode();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:header-style @style:page-layout-name=" + stylePageLayout.getStyleNameAttribute() + ", @style:family=" + stylePageLayout.getFamilyName() + " begin");
        }
        this.cssStyleSheet.startCSSStyleDeclaration(this.computeCSSClassName((OdfStyleBase)stylePageLayout, STYLE_NAME_HEADER));
        super.visit(ele);
        this.cssStyleSheet.endCSSStyleDeclaration();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:header-style @style:page-layout-name" + stylePageLayout.getStyleNameAttribute() + ", @style:family=" + stylePageLayout.getFamilyName() + " end");
        }
    }

    public void visit(StyleFooterStyleElement ele) {
        StylePageLayoutElement stylePageLayout = (StylePageLayoutElement)ele.getParentNode();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:footer-style @style:page-layout-name=" + stylePageLayout.getStyleNameAttribute() + ", @style:family=" + stylePageLayout.getFamilyName() + " begin");
        }
        this.cssStyleSheet.startCSSStyleDeclaration(this.computeCSSClassName((OdfStyleBase)stylePageLayout, STYLE_NAME_FOOTER));
        super.visit(ele);
        this.cssStyleSheet.endCSSStyleDeclaration();
        if (this.generateCSSComments) {
            this.cssStyleSheet.setComment("style:page-layout/style:footer-style @style:page-layout-name" + stylePageLayout.getStyleNameAttribute() + ", @style:family=" + stylePageLayout.getFamilyName() + " end");
        }
    }

    public void visit(StyleHeaderFooterPropertiesElement ele) {
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String minHeight;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty((String)backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty((String)(border = ele.getFoBorderAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border", border);
        }
        if (StringUtils.isNotEmpty((String)(borderBottom = ele.getFoBorderBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-bottom", borderBottom);
        }
        if (StringUtils.isNotEmpty((String)(borderLeft = ele.getFoBorderLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-left", borderLeft);
        }
        if (StringUtils.isNotEmpty((String)(borderRight = ele.getFoBorderRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-right", borderRight);
        }
        if (StringUtils.isNotEmpty((String)(borderTop = ele.getFoBorderTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-top", borderTop);
        }
        if (StringUtils.isNotEmpty((String)(margin = ele.getFoMarginAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin", margin);
        }
        if (StringUtils.isNotEmpty((String)(marginBottom = ele.getFoMarginBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-bottom", marginBottom);
        }
        if (StringUtils.isNotEmpty((String)(marginLeft = ele.getFoMarginLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-left", marginLeft);
        }
        if (StringUtils.isNotEmpty((String)(marginRight = ele.getFoMarginRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-right", marginRight);
        }
        if (StringUtils.isNotEmpty((String)(marginTop = ele.getFoMarginTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-top", marginTop);
        }
        if (StringUtils.isNotEmpty((String)(minHeight = ele.getFoMinHeightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("min-height", minHeight);
        }
        if (StringUtils.isNotEmpty((String)(padding = ele.getFoPaddingAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding", padding);
        }
        if (StringUtils.isNotEmpty((String)(paddingBottom = ele.getFoPaddingBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-bottom", paddingBottom);
        }
        if (StringUtils.isNotEmpty((String)(paddingLeft = ele.getFoPaddingLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-left", paddingLeft);
        }
        if (StringUtils.isNotEmpty((String)(paddingRight = ele.getFoPaddingRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-right", paddingRight);
        }
        if (StringUtils.isNotEmpty((String)(paddingTop = ele.getFoPaddingTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-top", paddingTop);
        }
    }

    public void visit(StyleParagraphPropertiesElement ele) {
        String textIndent;
        String textAlign;
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String lineHeight;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty((String)backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty((String)(border = ele.getFoBorderAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border", border);
        }
        if (StringUtils.isNotEmpty((String)(borderBottom = ele.getFoBorderBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-bottom", borderBottom);
        }
        if (StringUtils.isNotEmpty((String)(borderLeft = ele.getFoBorderLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-left", borderLeft);
        }
        if (StringUtils.isNotEmpty((String)(borderRight = ele.getFoBorderRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-right", borderRight);
        }
        if (StringUtils.isNotEmpty((String)(borderTop = ele.getFoBorderTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-top", borderTop);
        }
        if (StringUtils.isNotEmpty((String)(lineHeight = ele.getFoLineHeightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("line-height", lineHeight);
        }
        if (StringUtils.isNotEmpty((String)(margin = ele.getFoMarginAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin", margin);
        }
        if (StringUtils.isNotEmpty((String)(marginBottom = ele.getFoMarginBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-bottom", marginBottom);
        }
        if (StringUtils.isNotEmpty((String)(marginLeft = ele.getFoMarginLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-left", marginLeft);
        }
        if (StringUtils.isNotEmpty((String)(marginRight = ele.getFoMarginRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-right", marginRight);
        }
        if (StringUtils.isNotEmpty((String)(marginTop = ele.getFoMarginTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-top", marginTop);
        }
        if (StringUtils.isNotEmpty((String)(padding = ele.getFoPaddingAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding", padding);
        }
        if (StringUtils.isNotEmpty((String)(paddingBottom = ele.getFoPaddingBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-bottom", paddingBottom);
        }
        if (StringUtils.isNotEmpty((String)(paddingLeft = ele.getFoPaddingLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-left", paddingLeft);
        }
        if (StringUtils.isNotEmpty((String)(paddingRight = ele.getFoPaddingRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-right", paddingRight);
        }
        if (StringUtils.isNotEmpty((String)(paddingTop = ele.getFoPaddingTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-top", paddingTop);
        }
        if (StringUtils.isNotEmpty((String)(textAlign = ele.getFoTextAlignAttribute()))) {
            if ("start".equals(textAlign)) {
                textAlign = "left";
            } else if ("end".equals(textAlign)) {
                textAlign = "right";
            }
            this.cssStyleSheet.setCSSProperty("text-align", textAlign);
        }
        if (StringUtils.isNotEmpty((String)(textIndent = ele.getFoTextIndentAttribute()))) {
            this.cssStyleSheet.setCSSProperty("text-indent", textIndent);
        }
        super.visit(ele);
    }

    public void visit(StyleTextPropertiesElement ele) {
        String underlineType;
        String underlineStyle;
        String fontWeight;
        String fontVariant;
        String fontStyle;
        String fontSize;
        String fontName;
        String fontFamily;
        String color;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty((String)backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty((String)(color = ele.getFoColorAttribute()))) {
            this.cssStyleSheet.setCSSProperty("color", color);
        }
        if (StringUtils.isNotEmpty((String)(fontFamily = ele.getFoFontFamilyAttribute()))) {
            this.cssStyleSheet.setCSSProperty("font-family", "\"" + fontFamily + "\"");
        }
        if (StringUtils.isNotEmpty((String)(fontName = ele.getStyleFontNameAttribute()))) {
            this.cssStyleSheet.setCSSProperty("font-family", "\"" + fontName + "\"");
        }
        if (StringUtils.isNotEmpty((String)(fontSize = ele.getFoFontSizeAttribute()))) {
            this.cssStyleSheet.setCSSProperty("font-size", fontSize);
        }
        if (StringUtils.isNotEmpty((String)(fontStyle = ele.getFoFontStyleAttribute()))) {
            this.cssStyleSheet.setCSSProperty("font-style", fontStyle);
        }
        if (StringUtils.isNotEmpty((String)(fontVariant = ele.getFoFontVariantAttribute()))) {
            this.cssStyleSheet.setCSSProperty("font-variant", fontVariant);
        }
        if (StringUtils.isNotEmpty((String)(fontWeight = ele.getFoFontWeightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("font-weight", fontWeight);
        }
        if (StringUtils.isNotEmpty((String)(underlineStyle = ele.getStyleTextUnderlineStyleAttribute())) && !underlineStyle.equals("none")) {
            this.cssStyleSheet.setCSSProperty("text-decoration", "underline");
        }
        if (StringUtils.isNotEmpty((String)(underlineType = ele.getStyleTextUnderlineTypeAttribute())) && !underlineType.equals("none")) {
            this.cssStyleSheet.setCSSProperty("text-decoration", "underline");
        }
        super.visit(ele);
    }

    public void visit(StyleTablePropertiesElement ele) {
        String width;
        String borderModel;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty((String)backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty((String)(margin = ele.getFoMarginAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin", margin);
        }
        if (StringUtils.isNotEmpty((String)(marginBottom = ele.getFoMarginBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-bottom", marginBottom);
        }
        if (StringUtils.isNotEmpty((String)(marginLeft = ele.getFoMarginLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-left", marginLeft);
        }
        if (StringUtils.isNotEmpty((String)(marginRight = ele.getFoMarginRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-right", marginRight);
        }
        if (StringUtils.isNotEmpty((String)(marginTop = ele.getFoMarginTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-top", marginTop);
        }
        if (StringUtils.isNotEmpty((String)(borderModel = ele.getTableBorderModelAttribute()))) {
            if ("collapsing".equals(borderModel)) {
                this.cssStyleSheet.setCSSProperty("border-collapse", "collapse");
            } else {
                this.cssStyleSheet.setCSSProperty("border-collapse", "separate");
            }
        }
        if (StringUtils.isNotEmpty((String)(width = ele.getStyleWidthAttribute()))) {
            this.cssStyleSheet.setCSSProperty("width", width);
        }
        super.visit(ele);
    }

    public void visit(StyleTableColumnPropertiesElement ele) {
        String width = ele.getStyleColumnWidthAttribute();
        if (StringUtils.isNotEmpty((String)width)) {
            this.cssStyleSheet.setCSSProperty("width", width);
        }
        super.visit(ele);
    }

    public void visit(StyleTableRowPropertiesElement ele) {
        String height;
        String minHeight;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty((String)backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty((String)(minHeight = ele.getStyleMinRowHeightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("min-height", minHeight);
        }
        if (StringUtils.isNotEmpty((String)(height = ele.getStyleRowHeightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("height", minHeight);
        }
        super.visit(ele);
    }

    public void visit(StyleTableCellPropertiesElement ele) {
        String verticalAlign;
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty((String)backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty((String)(border = ele.getFoBorderAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border", border);
        }
        if (StringUtils.isNotEmpty((String)(borderBottom = ele.getFoBorderBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-bottom", borderBottom);
        }
        if (StringUtils.isNotEmpty((String)(borderLeft = ele.getFoBorderLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-left", borderLeft);
        }
        if (StringUtils.isNotEmpty((String)(borderRight = ele.getFoBorderRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-right", borderRight);
        }
        if (StringUtils.isNotEmpty((String)(borderTop = ele.getFoBorderTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-top", borderTop);
        }
        if (StringUtils.isNotEmpty((String)(padding = ele.getFoPaddingAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding", padding);
        }
        if (StringUtils.isNotEmpty((String)(paddingBottom = ele.getFoPaddingBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-bottom", paddingBottom);
        }
        if (StringUtils.isNotEmpty((String)(paddingLeft = ele.getFoPaddingLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-left", paddingLeft);
        }
        if (StringUtils.isNotEmpty((String)(paddingRight = ele.getFoPaddingRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-right", paddingRight);
        }
        if (StringUtils.isNotEmpty((String)(paddingTop = ele.getFoPaddingTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-top", paddingTop);
        }
        if (StringUtils.isNotEmpty((String)(verticalAlign = ele.getStyleVerticalAlignAttribute()))) {
            this.cssStyleSheet.setCSSProperty("vertical-align", verticalAlign);
        }
        super.visit(ele);
    }

    public void visit(StyleGraphicPropertiesElement ele) {
        String paddingTop;
        String paddingRight;
        String paddingLeft;
        String paddingBottom;
        String padding;
        String minWidth;
        String minHeight;
        String maxWidth;
        String maxHeight;
        String marginTop;
        String marginRight;
        String marginLeft;
        String marginBottom;
        String margin;
        String borderTop;
        String borderRight;
        String borderLeft;
        String borderBottom;
        String border;
        String backgroundColor = ele.getFoBackgroundColorAttribute();
        if (StringUtils.isNotEmpty((String)backgroundColor)) {
            this.cssStyleSheet.setCSSProperty("background-color", backgroundColor);
        }
        if (StringUtils.isNotEmpty((String)(border = ele.getFoBorderAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border", border);
        }
        if (StringUtils.isNotEmpty((String)(borderBottom = ele.getFoBorderBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-bottom", borderBottom);
        }
        if (StringUtils.isNotEmpty((String)(borderLeft = ele.getFoBorderLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-left", borderLeft);
        }
        if (StringUtils.isNotEmpty((String)(borderRight = ele.getFoBorderRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-right", borderRight);
        }
        if (StringUtils.isNotEmpty((String)(borderTop = ele.getFoBorderTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("border-top", borderTop);
        }
        if (StringUtils.isNotEmpty((String)(margin = ele.getFoMarginAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin", margin);
        }
        if (StringUtils.isNotEmpty((String)(marginBottom = ele.getFoMarginBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-bottom", marginBottom);
        }
        if (StringUtils.isNotEmpty((String)(marginLeft = ele.getFoMarginLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-left", marginLeft);
        }
        if (StringUtils.isNotEmpty((String)(marginRight = ele.getFoMarginRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-right", marginRight);
        }
        if (StringUtils.isNotEmpty((String)(marginTop = ele.getFoMarginTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("margin-top", marginTop);
        }
        if (StringUtils.isNotEmpty((String)(maxHeight = ele.getFoMaxHeightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("max-height", maxHeight);
        }
        if (StringUtils.isNotEmpty((String)(maxWidth = ele.getFoMaxWidthAttribute()))) {
            this.cssStyleSheet.setCSSProperty("max-width", maxWidth);
        }
        if (StringUtils.isNotEmpty((String)(minHeight = ele.getFoMinHeightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("min-height", minHeight);
        }
        if (StringUtils.isNotEmpty((String)(minWidth = ele.getFoMinWidthAttribute()))) {
            this.cssStyleSheet.setCSSProperty("min-width", minWidth);
        }
        if (StringUtils.isNotEmpty((String)(padding = ele.getFoPaddingAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding", padding);
        }
        if (StringUtils.isNotEmpty((String)(paddingBottom = ele.getFoPaddingBottomAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-bottom", paddingBottom);
        }
        if (StringUtils.isNotEmpty((String)(paddingLeft = ele.getFoPaddingLeftAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-left", paddingLeft);
        }
        if (StringUtils.isNotEmpty((String)(paddingRight = ele.getFoPaddingRightAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-right", paddingRight);
        }
        if (StringUtils.isNotEmpty((String)(paddingTop = ele.getFoPaddingTopAttribute()))) {
            this.cssStyleSheet.setCSSProperty("padding-top", paddingTop);
        }
        super.visit(ele);
    }

    private String computeCSSClassName(OdfStyleBase style) {
        return this.computeCSSClassName(style, null);
    }

    private String computeCSSClassName(OdfStyleBase style, String prefix) {
        StringBuilder classNames = new StringBuilder();
        String className = this.compute(style, classNames, true, prefix);
        this.classNamesMap.put(className, classNames.toString());
        return "." + className;
    }

    private String compute(OdfStyleBase style, StringBuilder classNames, boolean first, String prefix) {
        if (style == null) {
            return null;
        }
        String familyName = style.getFamilyName();
        String styleName = null;
        if (style instanceof StyleStyleElement) {
            styleName = ((StyleStyleElement)style).getStyleNameAttribute();
        } else if (style instanceof StylePageLayoutElement) {
            styleName = ((StylePageLayoutElement)style).getStyleNameAttribute();
        }
        String className = this.getClassName(familyName, styleName);
        if (prefix != null) {
            className = className + prefix;
        }
        if (first) {
            classNames.append(className);
        } else {
            classNames.insert(0, ' ');
            classNames.insert(0, className);
        }
        style = style.getParentStyle();
        if (style != null) {
            this.compute(style, classNames, false, prefix);
        }
        return className;
    }

    public String getClassName(String familyName, String styleName) {
        StringBuilder className = new StringBuilder();
        className.append(familyName);
        if (styleName != null) {
            className.append('_');
            className.append(StringUtils.replaceAll((String)styleName, (String)".", (String)"_"));
        }
        return className.toString();
    }

    public CSSStyleSheet getCSSStyleSheet() {
        return this.cssStyleSheet;
    }

    public String getMasterPageHeaderStyleName(String masterPageLayoutName) {
        return masterPageLayoutName + STYLE_NAME_HEADER;
    }

    public String getMasterPageFooterStyleName(String masterPageLayoutName) {
        return masterPageLayoutName + STYLE_NAME_FOOTER;
    }

    public void applyStyles(String familyName, String styleName, XHTMLPageContentBuffer xhtml) {
        String className = this.classNamesMap.get(this.getClassName(familyName, styleName));
        if (StringUtils.isNotEmpty((String)className)) {
            xhtml.setAttribute("class", className);
        }
    }

    public IURIResolver getURIResolver() {
        return this.resolver;
    }
}

