/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.converter.docx.poi.itext;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.MimeMappingConstants;
import fr.opensagres.xdocreport.converter.Options;
import fr.opensagres.xdocreport.converter.OptionsHelper;
import fr.opensagres.xdocreport.converter.XDocConverterException;
import fr.opensagres.xdocreport.converter.internal.AbstractConverterNoEntriesSupport;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.poi.xwpf.converter.pdf.PdfConverter;
import org.apache.poi.xwpf.converter.pdf.PdfOptions;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class XWPF2PDFViaITextConverter
extends AbstractConverterNoEntriesSupport {
    private static final XWPF2PDFViaITextConverter INSTANCE = new XWPF2PDFViaITextConverter();
    private static final Logger LOGGER = LogUtils.getLogger(XWPF2PDFViaITextConverter.class.getName());

    public static XWPF2PDFViaITextConverter getInstance() {
        return INSTANCE;
    }

    public void convert(InputStream in, OutputStream out, Options options) throws XDocConverterException {
        try {
            XWPFDocument document = new XWPFDocument(in);
            PdfConverter.getInstance().convert(document, out, this.toPdfOptions(options));
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new XDocConverterException(e);
        }
    }

    public PdfOptions toPdfOptions(Options options) {
        if (options == null) {
            return null;
        }
        Object value = options.getSubOptions(PdfOptions.class);
        if (value instanceof PdfOptions) {
            return (PdfOptions)value;
        }
        PdfOptions pdfOptions = PdfOptions.create();
        String fontEncoding = OptionsHelper.getFontEncoding(options);
        if (StringUtils.isNotEmpty(fontEncoding)) {
            pdfOptions.fontEncoding(fontEncoding);
        }
        return pdfOptions;
    }

    public MimeMapping getMimeMapping() {
        return MimeMappingConstants.PDF_MIME_MAPPING;
    }

    public boolean isDefault() {
        return true;
    }
}

