/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document;

import fr.opensagres.xdocreport.document.images.IImageHandler;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.document.registry.TextStylingRegistry;
import fr.opensagres.xdocreport.template.IContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentContextHelper {
    public static final String ELEMENTS_KEY = "___Elements";
    private static final String IMAGE_HANDLER_KEY = "___imageHandler";

    public static void putElementsCache(IContext context, Map<String, BufferedElement> elementsCache) {
        context.put(ELEMENTS_KEY, elementsCache);
    }

    public static Map<String, BufferedElement> getElementsCache(IContext context) {
        return (Map)context.get(ELEMENTS_KEY);
    }

    public static BufferedElement getElementById(IContext context, String elementId) {
        Map<String, BufferedElement> elements = DocumentContextHelper.getElementsCache(context);
        if (elements != null) {
            return elements.get(elementId);
        }
        return null;
    }

    public static void putTextStylingRegistry(IContext context, TextStylingRegistry registry) {
        context.put("___TextStylingRegistry", registry);
    }

    public static void putImageRegistry(IContext context, IImageRegistry imageRegistry) {
        context.put("___ImageRegistry", imageRegistry);
    }

    public static IImageRegistry getImageRegistry(IContext context) {
        return (IImageRegistry)context.get("___ImageRegistry");
    }

    public static void putImageHandler(IContext context, IImageHandler imageHandler) {
        context.put(IMAGE_HANDLER_KEY, imageHandler);
    }

    public static IImageHandler getImageHandler(IContext context) {
        return (IImageHandler)context.get(IMAGE_HANDLER_KEY);
    }
}

