/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes;

import fr.opensagres.xdocreport.document.docx.preprocessor.sax.DocXBufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.InitialNoteInfoMap;
import fr.opensagres.xdocreport.document.docx.preprocessor.sax.notes.NoteInfo;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedAttribute;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Map;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNoteReferenceBufferedRegion
extends BufferedElement {
    private static final String CONTEXT_NOTE = "___note";
    private final DocXBufferedDocumentContentHandler handler;
    private BufferedAttribute idAttribute;

    public AbstractNoteReferenceBufferedRegion(DocXBufferedDocumentContentHandler handler, BufferedElement parent, String uri, String localName, String name, Attributes attributes) {
        super(parent, uri, localName, name, attributes);
        this.handler = handler;
    }

    public void setId(String name, String value) {
        if (this.idAttribute == null) {
            this.idAttribute = super.setAttribute(name, value);
        }
        this.idAttribute.setValue(value);
        this.process();
    }

    private void process() {
        String id;
        NoteInfo info;
        InitialNoteInfoMap infos;
        IDocumentFormatter formatter = this.handler.getFormatter();
        if (this.handler.hasSharedContext() && formatter != null && (infos = this.getInitialNoteInfoMap(this.handler.getSharedContext())) != null && (info = (NoteInfo)infos.get(id = this.idAttribute.getValue())) != null) {
            String name = CONTEXT_NOTE;
            StringBuilder newId = new StringBuilder();
            newId.append(formatter.getDefineDirective(name, info.getContent()));
            newId.append(formatter.getFunctionDirective(this.getNoteRegistryKey(), "registerNote", "'" + id + "'", name));
            this.idAttribute.setValue(newId.toString());
        }
    }

    protected abstract String getNoteRegistryKey();

    protected abstract InitialNoteInfoMap getInitialNoteInfoMap(Map<String, Object> var1);
}

