/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.docx.preprocessor.sax.styles;

import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.docx.preprocessor.DefaultStyle;
import fr.opensagres.xdocreport.document.docx.template.DocxContextHelper;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedDocumentContentHandler;
import fr.opensagres.xdocreport.document.preprocessor.sax.BufferedElement;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocxStylesDocumentContentHandler
extends BufferedDocumentContentHandler {
    private static final String STYLE_ELT = "style";
    private static final String STYLES_ELT = "styles";
    private static final String NAME_ELT = "name";
    private static final String W_STYLE_ID_ATTR = "w:styleId";
    private static final String W_VAL_ATTR = "w:val";
    private static final String HYPERLINK_STYLE_NAME = "Hyperlink";
    private final IDocumentFormatter formatter;
    private final Map<String, Object> sharedContext;
    private String currentStyleId = null;

    public DocxStylesDocumentContentHandler(IDocumentFormatter formatter, Map<String, Object> sharedContext) {
        this.formatter = formatter;
        this.sharedContext = sharedContext;
    }

    @Override
    public boolean doStartElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        String val;
        if (STYLE_ELT.equals(localName)) {
            this.currentStyleId = attributes.getValue(W_STYLE_ID_ATTR);
        } else if (NAME_ELT.equals(localName) && StringUtils.isNotEmpty(val = attributes.getValue(W_VAL_ATTR))) {
            String index;
            Integer level;
            if (HYPERLINK_STYLE_NAME.equals(val)) {
                DefaultStyle defaultStyle = DocxContextHelper.getDefaultStyle(this.sharedContext);
                defaultStyle.setHyperLinkStyleId(this.currentStyleId);
            } else if (val.startsWith("heading ") && (level = StringUtils.asInteger(index = val.substring("heading ".length(), val.length()))) != null) {
                DefaultStyle defaultStyle = DocxContextHelper.getDefaultStyle(this.sharedContext);
                defaultStyle.addHeaderStyle(level, this.currentStyleId);
            }
        }
        return super.doStartElement(uri, localName, name, attributes);
    }

    @Override
    public void doEndElement(String uri, String localName, String name) throws SAXException {
        if (STYLE_ELT.equals(localName)) {
            this.currentStyleId = null;
        } else if (STYLES_ELT.equals(localName)) {
            BufferedElement region = this.getCurrentElement();
            region.append(this.formatter.getFunctionDirective("___NoEscapeStylesGenerator", "generateAllStyles", "___DefaultStyle"));
        }
        super.doEndElement(uri, localName, name);
    }

    public IDocumentFormatter getFormatter() {
        return this.formatter;
    }
}

