/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.dump;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.converter.MimeMappingConstants;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.dump.AbstractDumper;
import fr.opensagres.xdocreport.document.dump.DumpHelper;
import fr.opensagres.xdocreport.document.dump.DumperKind;
import fr.opensagres.xdocreport.document.dump.DumperOptions;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;

public abstract class AbstractProjectDumper
extends AbstractDumper {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDump(IXDocReport report, InputStream documentIn, IContext context, DumperOptions option, ITemplateEngine templateEngine, OutputStream out) throws IOException, XDocReportException {
        IContext dumpContext = DumpHelper.createDumpContext(report, templateEngine, option);
        File baseDir = null;
        String packageName = null;
        if (option != null) {
            baseDir = (File)option.get("baseDir");
            packageName = option.getPackageName();
        }
        if (baseDir != null) {
            baseDir.mkdirs();
            this.doDump(report, documentIn, context, templateEngine, dumpContext, baseDir, null);
        } else {
            ZipOutputStream zipOutputStream = null;
            try {
                zipOutputStream = new ZipOutputStream(out);
                this.doDump(report, documentIn, context, templateEngine, dumpContext, null, zipOutputStream);
            }
            finally {
                if (zipOutputStream != null) {
                    IOUtils.closeQuietly(zipOutputStream);
                }
            }
        }
    }

    protected void doDump(IXDocReport report, InputStream documentIn, IContext context, ITemplateEngine templateEngine, IContext dumpContext, File baseDir, ZipOutputStream out) throws IOException, XDocReportException {
        String resourcesSrcPath = this.getResourcesSrcPath();
        DumpHelper.generateDocumentEntry(report, documentIn, dumpContext, resourcesSrcPath, baseDir, out);
        boolean upperCaseFirstChar = templateEngine.isFieldNameStartsWithUpperCase();
        DumpHelper.generateJSONEntry(report, context, upperCaseFirstChar, dumpContext, resourcesSrcPath, baseDir, out);
        DumpHelper.generateFieldsMetadataEntry(report, dumpContext, resourcesSrcPath, baseDir, out);
        String javaSrcPath = this.getJavaSrcPath();
        String classNameFile = DumpHelper.getClassNameFile(dumpContext);
        String javaPath = javaSrcPath + "/" + classNameFile;
        DumpHelper.generateEntry(templateEngine, "JavaMainDump", dumpContext, javaPath, baseDir, out);
    }

    public MimeMapping getMimeMapping() {
        return MimeMappingConstants.ZIP_MIME_MAPPING;
    }

    protected abstract String getJavaSrcPath();

    protected abstract String getResourcesSrcPath();

    public static class ProjectDumperOption
    extends DumperOptions {
        public static final String BASEDIR = "baseDir";

        public ProjectDumperOption(DumperKind kind) {
            super(kind);
        }

        public void setBaseDir(File baseDir) {
            super.put(BASEDIR, baseDir);
        }

        public File getBaseDir() {
            return (File)this.get(BASEDIR);
        }
    }
}

