/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.images;

import fr.opensagres.xdocreport.core.document.ImageFormat;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.document.images.AbstractImageProvider;
import fr.opensagres.xdocreport.document.images.SimpleImageInfo;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteArrayImageProvider
extends AbstractImageProvider {
    private byte[] imageByteArray;

    public ByteArrayImageProvider(InputStream imageStream) throws IOException {
        this(imageStream, false);
    }

    public ByteArrayImageProvider(InputStream imageStream, boolean useImageSize) throws IOException {
        this(imageStream != null ? IOUtils.toByteArray(imageStream) : null, useImageSize);
    }

    public ByteArrayImageProvider(byte[] imageByteArray) {
        this(imageByteArray, false);
    }

    public ByteArrayImageProvider(byte[] imageByteArray, boolean useImageSize) {
        super(useImageSize);
        this.setImageByteArray(imageByteArray);
    }

    public void setImageStream(InputStream imageStream) throws IOException {
        this.setImageByteArray(IOUtils.toByteArray(imageStream));
    }

    public void setImageByteArray(byte[] imageByteArray) {
        this.imageByteArray = imageByteArray;
        super.resetImageInfo();
    }

    public InputStream getImageStream() {
        return new ByteArrayInputStream(this.getImageByteArray());
    }

    public byte[] getImageByteArray() {
        return this.imageByteArray;
    }

    public void write(OutputStream output) throws IOException {
        IOUtils.write(this.imageByteArray, output);
    }

    public ImageFormat getImageFormat() {
        try {
            SimpleImageInfo imageInfo = this.getImageInfo();
            if (imageInfo == null) {
                return null;
            }
            return imageInfo.getMimeType();
        }
        catch (IOException e) {
            return null;
        }
    }

    protected SimpleImageInfo loadImageInfo() throws IOException {
        if (this.imageByteArray == null) {
            return null;
        }
        return new SimpleImageInfo(this.imageByteArray);
    }

    protected boolean doIsValid() {
        return this.getImageByteArray() != null;
    }
}

