/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.images;

import fr.opensagres.xdocreport.core.document.ImageFormat;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SimpleImageInfo {
    private int height;
    private int width;
    private ImageFormat mimeType;

    private SimpleImageInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleImageInfo(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            this.processStream(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public SimpleImageInfo(InputStream is) throws IOException {
        this.processStream(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleImageInfo(byte[] bytes) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        try {
            this.processStream(is);
        }
        finally {
            ((InputStream)is).close();
        }
    }

    private void processStream(InputStream is) throws IOException {
        int c1 = is.read();
        int c2 = is.read();
        int c3 = is.read();
        this.mimeType = null;
        this.height = -1;
        this.width = -1;
        if (c1 == 71 && c2 == 73 && c3 == 70) {
            is.skip(3L);
            this.width = this.readInt(is, 2, false);
            this.height = this.readInt(is, 2, false);
            this.mimeType = ImageFormat.gif;
        } else if (c1 == 255 && c2 == 216) {
            while (c3 == 255) {
                int marker = is.read();
                int len = this.readInt(is, 2, true);
                if (marker == 192 || marker == 193 || marker == 194) {
                    is.skip(1L);
                    this.height = this.readInt(is, 2, true);
                    this.width = this.readInt(is, 2, true);
                    this.mimeType = ImageFormat.jpeg;
                    break;
                }
                is.skip(len - 2);
                c3 = is.read();
            }
        } else if (c1 == 137 && c2 == 80 && c3 == 78) {
            is.skip(15L);
            this.width = this.readInt(is, 2, true);
            is.skip(2L);
            this.height = this.readInt(is, 2, true);
            this.mimeType = ImageFormat.png;
        } else if (c1 == 66 && c2 == 77) {
            is.skip(15L);
            this.width = this.readInt(is, 2, false);
            is.skip(2L);
            this.height = this.readInt(is, 2, false);
            this.mimeType = ImageFormat.bmp;
        } else {
            int c4 = is.read();
            if (c1 == 77 && c2 == 77 && c3 == 0 && c4 == 42 || c1 == 73 && c2 == 73 && c3 == 42 && c4 == 0) {
                boolean bigEndian = c1 == 77;
                int ifd = 0;
                ifd = this.readInt(is, 4, bigEndian);
                is.skip(ifd - 8);
                int entries = this.readInt(is, 2, bigEndian);
                for (int i = 1; i <= entries; ++i) {
                    int valOffset;
                    int tag = this.readInt(is, 2, bigEndian);
                    int fieldType = this.readInt(is, 2, bigEndian);
                    long count = this.readInt(is, 4, bigEndian);
                    if (fieldType == 3 || fieldType == 8) {
                        valOffset = this.readInt(is, 2, bigEndian);
                        is.skip(2L);
                    } else {
                        valOffset = this.readInt(is, 4, bigEndian);
                    }
                    if (tag == 256) {
                        this.width = valOffset;
                    } else if (tag == 257) {
                        this.height = valOffset;
                    }
                    if (this.width == -1 || this.height == -1) continue;
                    this.mimeType = ImageFormat.tiff;
                    break;
                }
            }
        }
        if (this.mimeType == null) {
            throw new IOException("Unsupported image type");
        }
    }

    private int readInt(InputStream is, int noOfBytes, boolean bigEndian) throws IOException {
        int ret = 0;
        int sv = bigEndian ? (noOfBytes - 1) * 8 : 0;
        int cnt = bigEndian ? -8 : 8;
        for (int i = 0; i < noOfBytes; ++i) {
            ret |= is.read() << sv;
            sv += cnt;
        }
        return ret;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public ImageFormat getMimeType() {
        return this.mimeType;
    }

    public String toString() {
        return "MIME Type : " + (Object)((Object)this.mimeType) + "\t Width : " + this.width + "\t Height : " + this.height;
    }
}

