/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.odt;

import fr.opensagres.xdocreport.converter.MimeMapping;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.document.DocumentKind;
import fr.opensagres.xdocreport.core.io.IEntryOutputStreamProvider;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.document.AbstractXDocReport;
import fr.opensagres.xdocreport.document.images.IImageRegistry;
import fr.opensagres.xdocreport.document.odt.ODTConstants;
import fr.opensagres.xdocreport.document.odt.images.ODTImageRegistry;
import fr.opensagres.xdocreport.document.odt.preprocessor.ODTManifestXMLProcessor;
import fr.opensagres.xdocreport.document.odt.preprocessor.ODTPreprocessor;
import fr.opensagres.xdocreport.document.odt.preprocessor.ODTStylesPreprocessor;
import fr.opensagres.xdocreport.document.odt.template.ODTContextHelper;
import fr.opensagres.xdocreport.document.odt.textstyling.ODTDefaultStyle;
import fr.opensagres.xdocreport.template.IContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODTReport
extends AbstractXDocReport {
    private static final long serialVersionUID = 5974669564624835649L;
    private static final String[] DEFAULT_XML_ENTRIES = new String[]{"content.xml", "styles.xml", "META-INF/manifest.xml"};
    private ODTDefaultStyle defaultStyle = new ODTDefaultStyle();

    @Override
    public String getKind() {
        return DocumentKind.ODT.name();
    }

    @Override
    public MimeMapping getMimeMapping() {
        return ODTConstants.MIME_MAPPING;
    }

    @Override
    protected void registerPreprocessors() {
        super.addPreprocessor("content.xml", ODTPreprocessor.INSTANCE);
        super.addPreprocessor("META-INF/manifest.xml", ODTManifestXMLProcessor.INSTANCE);
        super.addPreprocessor("styles.xml", ODTStylesPreprocessor.INSTANCE);
    }

    @Override
    protected void onBeforePreprocessing(Map<String, Object> sharedContext, XDocArchive preprocessedArchive) throws XDocReportException {
        super.onBeforePreprocessing(sharedContext, preprocessedArchive);
        sharedContext.put("___DefaultStyle", this.defaultStyle);
    }

    @Override
    protected void onBeforeProcessTemplateEngine(IContext context, XDocArchive outputArchive) throws XDocReportException {
        super.onBeforeProcessTemplateEngine(context, outputArchive);
        ODTContextHelper.putDefaultStyle(context, this.defaultStyle);
        ODTContextHelper.getStylesGenerator(context);
    }

    @Override
    protected String[] getDefaultXMLEntries() {
        return DEFAULT_XML_ENTRIES;
    }

    @Override
    protected IImageRegistry createImageRegistry(IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IEntryOutputStreamProvider outputStreamProvider) {
        return new ODTImageRegistry(readerProvider, writerProvider, outputStreamProvider, this.getFieldsMetadata());
    }
}

