/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.preprocessor;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.io.MultiWriter;
import fr.opensagres.xdocreport.core.io.StreamCancelable;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.utils.XMLUtils;
import fr.opensagres.xdocreport.document.preprocessor.IXDocPreprocessor;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractXDocPreprocessor<T>
implements IXDocPreprocessor {
    private static final Logger LOGGER = LogUtils.getLogger(AbstractXDocPreprocessor.class.getName());

    @Override
    public void preprocess(String entryName, XDocArchive documentArchive, FieldsMetadata fieldsMetadata, IDocumentFormatter formater, Map<String, Object> sharedContext) throws XDocReportException, IOException {
        if (fieldsMetadata == null) {
            fieldsMetadata = FieldsMetadata.EMPTY;
        }
        long startTime = -1L;
        if (LOGGER.isLoggable(Level.FINE)) {
            startTime = System.currentTimeMillis();
            LOGGER.fine("Start preprocess for the entry=" + entryName);
        }
        T reader = null;
        Writer writer = null;
        boolean result = false;
        try {
            reader = this.getSource(documentArchive, entryName);
            writer = this.getWriter(entryName, documentArchive);
            result = this.preprocess(entryName, reader, writer, fieldsMetadata, formater, sharedContext);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Result preprocess for the entry=" + entryName + ": " + XMLUtils.prettyPrint(((MultiWriter)writer).getWriter(1).toString()));
                LOGGER.fine("End preprocess for the entry=" + entryName + " done with " + (System.currentTimeMillis() - startTime) + "(ms).");
            }
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("End preprocess for the entry=" + entryName + " done with " + (System.currentTimeMillis() - startTime) + "(ms).");
                LOGGER.throwing(this.getClass().getName(), "preprocess", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof XDocReportException) {
                throw (XDocReportException)e;
            }
            throw new XDocReportException(e);
        }
        finally {
            this.closeSource(reader);
            if (writer != null) {
                if (result) {
                    IOUtils.closeQuietly(writer);
                } else {
                    ((StreamCancelable)((Object)writer)).cancel();
                }
            }
        }
    }

    protected abstract void closeSource(T var1) throws XDocReportException, IOException;

    private Writer getWriter(String entryName, XDocArchive documentArchive) {
        if (LOGGER.isLoggable(Level.FINE)) {
            return new MultiWriter(documentArchive.getEntryWriter(entryName), new StringWriter());
        }
        return documentArchive.getEntryWriter(entryName);
    }

    @Override
    public boolean create(String entryName, XDocArchive outputArchive, FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext) throws XDocReportException, IOException {
        return false;
    }

    protected void createAndProcess(String entryName, XDocArchive outputArchive, FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext, InputStream input) throws IOException, XDocReportException {
        XDocArchive.setEntry(outputArchive, entryName, input);
        this.preprocess(entryName, outputArchive, fieldsMetadata, formatter, sharedContext);
    }

    public abstract boolean preprocess(String var1, T var2, Writer var3, FieldsMetadata var4, IDocumentFormatter var5, Map<String, Object> var6) throws XDocReportException, IOException;

    protected abstract T getSource(XDocArchive var1, String var2) throws XDocReportException, IOException;
}

