/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.preprocessor.dom;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.XDocArchive;
import fr.opensagres.xdocreport.core.utils.DOMUtils;
import fr.opensagres.xdocreport.document.preprocessor.AbstractXDocPreprocessor;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DOMPreprocessor
extends AbstractXDocPreprocessor<Document> {
    @Override
    protected Document getSource(XDocArchive documentArchive, String entryName) throws XDocReportException, IOException {
        try {
            return DOMUtils.load(documentArchive.getEntryInputStream(entryName));
        }
        catch (ParserConfigurationException e) {
            throw new XDocReportException(e);
        }
        catch (SAXException e) {
            throw new XDocReportException(e);
        }
    }

    @Override
    protected void closeSource(Document reader) {
    }

    @Override
    public boolean preprocess(String entryName, Document document, Writer writer, FieldsMetadata fieldsMetadata, IDocumentFormatter formatter, Map<String, Object> sharedContext) throws XDocReportException, IOException {
        try {
            this.visit(document, entryName, fieldsMetadata, formatter, sharedContext);
            DOMUtils.save((Node)document, writer);
            return true;
        }
        catch (TransformerException e) {
            throw new XDocReportException(e);
        }
    }

    protected abstract void visit(Document var1, String var2, FieldsMetadata var3, IDocumentFormatter var4, Map<String, Object> var5) throws XDocReportException;

    protected void updateDynamicAttr(Element element, String attrName, String contextKey, IDocumentFormatter formatter) {
        if (element.hasAttribute(attrName)) {
            element.setAttribute(attrName, this.getDynamicAttr(element, attrName, contextKey, contextKey, formatter));
        }
    }

    protected void updateDynamicAttr(Element element, String attrName, String contextIfKey, String contextValueKey, IDocumentFormatter formatter) {
        if (element.hasAttribute(attrName)) {
            element.setAttribute(attrName, this.getDynamicAttr(element, attrName, contextIfKey, contextValueKey, formatter));
        }
    }

    protected String getDynamicAttr(Element element, String attrName, String contextIfKey, String contextValueKey, IDocumentFormatter formatter) {
        StringBuilder value = new StringBuilder();
        value.append(formatter.getStartIfDirective(contextIfKey));
        value.append(formatter.formatAsSimpleField(true, contextValueKey));
        value.append(formatter.getElseDirective());
        value.append(element.getAttribute(attrName));
        value.append(formatter.getEndIfDirective(contextIfKey));
        return value.toString();
    }
}

