/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.IEntryReaderProvider;
import fr.opensagres.xdocreport.core.io.IEntryWriterProvider;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.core.io.MultiWriter;
import fr.opensagres.xdocreport.core.logging.LogUtils;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.core.utils.XMLUtils;
import fr.opensagres.xdocreport.template.FieldsExtractor;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.ITemplateEngine;
import fr.opensagres.xdocreport.template.cache.ITemplateCacheInfoProvider;
import fr.opensagres.xdocreport.template.config.ITemplateEngineConfiguration;
import fr.opensagres.xdocreport.template.utils.TemplateUtils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractTemplateEngine
implements ITemplateEngine {
    private ITemplateCacheInfoProvider templateCacheInfoProvider;
    private ITemplateEngineConfiguration configuration;
    private static final Logger LOGGER = LogUtils.getLogger(AbstractTemplateEngine.class.getName());

    public ITemplateCacheInfoProvider getTemplateCacheInfoProvider() {
        return this.templateCacheInfoProvider;
    }

    public void setTemplateCacheInfoProvider(ITemplateCacheInfoProvider templateCacheInfoProvider) {
        this.templateCacheInfoProvider = templateCacheInfoProvider;
    }

    public ITemplateEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ITemplateEngineConfiguration configuration) {
        this.configuration = configuration;
    }

    public void process(String reportId, String entryName, IEntryReaderProvider readerProvider, IEntryWriterProvider writerProvider, IContext context) throws XDocReportException, IOException {
        Writer writer = writerProvider.getEntryWriter(entryName);
        this.process(reportId, entryName, readerProvider, writer, context);
    }

    public void process(String reportId, String entryName, IEntryReaderProvider readerProvider, Writer writer, IContext context) throws XDocReportException, IOException {
        block15: {
            boolean useTemplateCache = this.isUseTemplateCache(reportId);
            long startTime = -1L;
            if (LOGGER.isLoggable(Level.FINE)) {
                startTime = System.currentTimeMillis();
                LOGGER.fine(String.format("Start template engine id=%s for the entry=%s with template cache=%s", this.getId(), entryName, useTemplateCache));
            }
            Reader reader = null;
            try {
                writer = this.getWriter(writer);
                if (useTemplateCache) {
                    this.processWithCache(TemplateUtils.getCachedTemplateName(reportId, entryName), context, writer);
                } else {
                    reader = readerProvider.getEntryReader(entryName);
                    this.processNoCache(entryName, context, reader, writer);
                }
                if (LOGGER.isLoggable(Level.FINE)) {
                    startTime = System.currentTimeMillis();
                    LOGGER.fine(String.format("Result template engine id=" + this.getId() + "  for the entry=" + entryName + ": ", new Object[0]));
                    LOGGER.fine(XMLUtils.prettyPrint(((MultiWriter)writer).getWriter(1).toString()));
                    LOGGER.fine("End template engine id=" + this.getId() + " for the entry=" + entryName + " done with " + (System.currentTimeMillis() - startTime) + "(ms).");
                }
                if (reader == null) break block15;
            }
            catch (Throwable e) {
                try {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("End template engine id=" + this.getId() + " for the entry=" + entryName + " done with " + (System.currentTimeMillis() - startTime) + "(ms).");
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    if (e instanceof XDocReportException) {
                        throw (XDocReportException)e;
                    }
                    throw new XDocReportException(e);
                }
                catch (Throwable throwable) {
                    if (reader != null) {
                        IOUtils.closeQuietly(reader);
                    }
                    if (writer != null) {
                        IOUtils.closeQuietly(writer);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(reader);
        }
        if (writer != null) {
            IOUtils.closeQuietly(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String entryName, IContext context, Reader reader, Writer writer) throws XDocReportException, IOException {
        try {
            this.processNoCache(entryName, context, reader, writer);
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
            if (writer != null) {
                IOUtils.closeQuietly(writer);
            }
        }
    }

    public void extractFields(IEntryReaderProvider readerProvider, String entryName, FieldsExtractor extractor) throws XDocReportException {
        Reader reader = readerProvider.getEntryReader(entryName);
        this.extractFields(reader, entryName, extractor);
    }

    private Writer getWriter(Writer writer) {
        if (LOGGER.isLoggable(Level.FINE)) {
            return new MultiWriter(writer, new StringWriter());
        }
        return writer;
    }

    protected boolean isUseTemplateCache(String reportId) {
        return StringUtils.isNotEmpty(reportId) && this.getTemplateCacheInfoProvider() != null && this.getTemplateCacheInfoProvider().existsReport(reportId);
    }

    protected abstract void processWithCache(String var1, IContext var2, Writer var3) throws XDocReportException, IOException;

    protected abstract void processNoCache(String var1, IContext var2, Reader var3, Writer var4) throws XDocReportException, IOException;
}

