/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.template.velocity.internal;

import fr.opensagres.xdocreport.core.EncodingConstants;
import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.io.IOUtils;
import fr.opensagres.xdocreport.template.AbstractTemplateEngine;
import fr.opensagres.xdocreport.template.FieldsExtractor;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.TemplateEngineKind;
import fr.opensagres.xdocreport.template.config.ITemplateEngineConfiguration;
import fr.opensagres.xdocreport.template.formatter.IDocumentFormatter;
import fr.opensagres.xdocreport.template.velocity.VelocityConstants;
import fr.opensagres.xdocreport.template.velocity.VelocityDocumentFormatter;
import fr.opensagres.xdocreport.template.velocity.VelocityFieldsExtractor;
import fr.opensagres.xdocreport.template.velocity.internal.XDocReportEscapeReference;
import fr.opensagres.xdocreport.template.velocity.internal.XDocVelocityContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import java.util.Properties;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityTemplateEngine
extends AbstractTemplateEngine
implements VelocityConstants {
    private static String ID = TemplateEngineKind.Velocity.name();
    private VelocityDocumentFormatter formatter = new VelocityDocumentFormatter();
    private VelocityEngine velocityEngine;
    private final Properties velocityEngineProperties;

    public VelocityTemplateEngine(Properties velocityEngineProperties) {
        this.velocityEngineProperties = velocityEngineProperties;
    }

    @Override
    public String getKind() {
        return TemplateEngineKind.Velocity.name();
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public IContext createContext() {
        return new XDocVelocityContext();
    }

    @Override
    public IContext createContext(Map<String, Object> contextMap) {
        return new XDocVelocityContext(contextMap);
    }

    @Override
    protected void processWithCache(String templateName, IContext context, Writer writer) throws XDocReportException, IOException {
        VelocityEngine velocityEngine = this.getVelocityEngine();
        Template template = velocityEngine.getTemplate(templateName, EncodingConstants.UTF_8.name());
        if (template != null) {
            template.merge((Context)((VelocityContext)context), writer);
        }
    }

    @Override
    protected void processNoCache(String entryName, IContext context, Reader reader, Writer writer) throws XDocReportException, IOException {
        VelocityEngine velocityEngine = this.getVelocityEngine();
        velocityEngine.evaluate((Context)((VelocityContext)context), writer, "", reader);
    }

    protected synchronized VelocityEngine getVelocityEngine() throws XDocReportException {
        if (this.velocityEngine == null) {
            this.velocityEngine = new VelocityEngine();
            this.initializeVelocityEngine(this.velocityEngineProperties);
        }
        return this.velocityEngine;
    }

    public void initializeVelocityEngine(Properties velocityEngineProperties) throws XDocReportException {
        ClassLoader backupCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(VelocityTemplateEngine.class.getClassLoader());
        try {
            this.velocityEngine.setProperty("velocityTemplateEngine", (Object)this);
            this.velocityEngine.init(velocityEngineProperties);
        }
        catch (Exception e) {
            throw new XDocReportException(e);
        }
        Thread.currentThread().setContextClassLoader(backupCL);
    }

    @Override
    public void setConfiguration(ITemplateEngineConfiguration configuration) {
        super.setConfiguration(configuration);
        if (configuration != null && configuration.escapeXML()) {
            this.velocityEngineProperties.setProperty("eventhandler.referenceinsertion.class", XDocReportEscapeReference.class.getName());
        }
    }

    @Override
    public IDocumentFormatter getDocumentFormatter() {
        return this.formatter;
    }

    @Override
    public void extractFields(Reader reader, String entryName, FieldsExtractor extractor) throws XDocReportException {
        VelocityFieldsExtractor.getInstance().extractFields(reader, entryName, extractor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(String templateName, IContext context, Writer writer) throws IOException, XDocReportException {
        templateName = templateName + ".vm";
        InputStreamReader reader = new InputStreamReader(VelocityTemplateEngine.class.getResourceAsStream(templateName));
        try {
            VelocityEngine velocityEngine = this.getVelocityEngine();
            velocityEngine.evaluate((Context)((VelocityContext)context), writer, "", (Reader)reader);
        }
        finally {
            if (reader != null) {
                IOUtils.closeQuietly(reader);
            }
        }
    }

    @Override
    public boolean isFieldNameStartsWithUpperCase() {
        return false;
    }
}

