/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.converter.core.openxmlformats;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xwpf.converter.core.openxmlformats.AbstractOpenXMLFormatsPartProvider;
import org.apache.poi.xwpf.converter.core.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipArchive
extends AbstractOpenXMLFormatsPartProvider {
    private static final String MIMETYPE_ENTRY_NAME = "mimetype";
    private Map<String, byte[]> cacheEntries = new LinkedHashMap<String, byte[]>();
    private Map<String, Long> lastModifiedEntries;
    private Map<String, Set<String>> cacheEntriesWilcard = null;

    public ZipArchive() {
        this(false);
    }

    public ZipArchive(boolean trackLastModified) {
        this.lastModifiedEntries = trackLastModified ? new HashMap<String, Long>() : null;
    }

    public Set<String> getEntryNames() {
        return this.cacheEntries.keySet();
    }

    public Set<String> getEntryNames(String wildcard) {
        Set<String> entryNamesWithWildcard;
        if (this.cacheEntriesWilcard == null) {
            this.cacheEntriesWilcard = new HashMap<String, Set<String>>();
        }
        if ((entryNamesWithWildcard = this.cacheEntriesWilcard.get(wildcard)) != null) {
            return entryNamesWithWildcard;
        }
        String regexp = ZipArchive.wildcardToRegex(wildcard);
        entryNamesWithWildcard = new HashSet<String>();
        Set<String> entryNames = this.getEntryNames();
        for (String entryName : entryNames) {
            if (!entryName.matches(regexp)) continue;
            entryNamesWithWildcard.add(entryName);
        }
        this.cacheEntriesWilcard.put(wildcard, entryNamesWithWildcard);
        return entryNamesWithWildcard;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    @Override
    public InputStream getEntryInputStream(String entryName) {
        if (!this.cacheEntries.containsKey(entryName)) {
            return null;
        }
        return new ByteArrayInputStream(this.cacheEntries.get(entryName));
    }

    public OutputStream getEntryOutputStream(String entryName) {
        return new EntryByteArrayOutputStream(entryName);
    }

    public ZipArchive createCopy() {
        ZipArchive archiveCopy = new ZipArchive();
        for (Map.Entry<String, byte[]> entry : this.cacheEntries.entrySet()) {
            String name = entry.getKey();
            byte[] entryData = entry.getValue();
            byte[] entryDataCopy = new byte[entryData.length];
            System.arraycopy(entryData, 0, entryDataCopy, 0, entryData.length);
            archiveCopy.cacheEntries.put(name, entryDataCopy);
        }
        return archiveCopy;
    }

    public boolean hasEntry(String entryName) {
        return this.cacheEntries.containsKey(entryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipArchive readZip(InputStream sourceStream) throws IOException {
        if (sourceStream == null) {
            throw new IOException("InputStream cannot be null.");
        }
        ZipArchive archive = null;
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(sourceStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (archive == null) {
                    archive = new ZipArchive(true);
                }
                ZipArchive.setEntry(archive, zipEntry.getName(), zipInputStream);
                zipInputStream.closeEntry();
            }
        }
        finally {
            if (zipInputStream != null) {
                zipInputStream.close();
            }
        }
        if (archive == null) {
            throw new IOException("InputStream is not a zip.");
        }
        return archive;
    }

    public static void setEntry(ZipArchive archive, String entryName, InputStream input) throws IOException {
        if (entryName.indexOf("\\") != -1) {
            entryName = StringUtils.replaceAll(entryName, "\\", "/");
        }
        OutputStream output = archive.getEntryOutputStream(entryName);
        IOUtils.copy((InputStream)input, (OutputStream)output);
        output.close();
    }

    public static void writeEntry(ZipArchive archive, String entryName, OutputStream outputStream) throws IOException {
        if (!archive.hasEntry(entryName)) {
            throw new IOException("Cannot find entry name=" + entryName + " in the document archive.");
        }
        outputStream.write(archive.cacheEntries.get(entryName));
    }

    public static void writeZip(ZipArchive archive, OutputStream outputStream) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);
        Set<String> entryNames = archive.getEntryNames();
        for (String entryName : entryNames) {
            if (MIMETYPE_ENTRY_NAME.equals(entryName)) continue;
            ZipArchive.writeZipEntry(zipOutputStream, archive, entryName, 8);
        }
        zipOutputStream.close();
    }

    private static void writeZipEntry(ZipOutputStream zipOutputStream, ZipArchive archive, String entryName, int method) throws IOException {
        InputStream entryInputStream = archive.getEntryInputStream(entryName);
        if (entryInputStream == null) {
            return;
        }
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipEntry.setMethod(method);
        zipOutputStream.putNextEntry(zipEntry);
        IOUtils.copy((InputStream)entryInputStream, (OutputStream)zipOutputStream);
        IOUtils.closeQuietly((Closeable)entryInputStream);
        zipOutputStream.closeEntry();
    }

    private boolean isTrackLastModified() {
        return this.lastModifiedEntries != null;
    }

    public long getLastModifiedEntry(String entryName) {
        Long lastModified;
        if (this.isTrackLastModified() && (lastModified = this.lastModifiedEntries.get(entryName)) != null) {
            return lastModified;
        }
        return 0L;
    }

    public void dispose() {
        if (this.cacheEntries != null) {
            this.cacheEntries.clear();
        }
        this.cacheEntries = null;
        if (this.lastModifiedEntries != null) {
            this.lastModifiedEntries.clear();
        }
        this.lastModifiedEntries = null;
    }

    private class EntryByteArrayOutputStream
    extends ByteArrayOutputStream {
        private String entryName;

        public EntryByteArrayOutputStream(String entryName) {
            this.entryName = entryName;
        }

        public void close() throws IOException {
            ZipArchive.this.cacheEntries.put(this.entryName, this.toByteArray());
            if (ZipArchive.this.isTrackLastModified()) {
                ZipArchive.this.lastModifiedEntries.put(this.entryName, System.currentTimeMillis());
            }
            ZipArchive.this.cacheEntriesWilcard = null;
        }
    }
}

